/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.json.JsonFactory;

public class JsonSerializationUtils {
    public static final String ENCODING = "UTF-8";
    protected final DataFactory _dataFactory = DataFactoryCreator.createDefaultFactory();
    protected final IpcFactory _jsonFactory = new JsonFactory();
    protected final ValueFormatHelper _formatHelper = new ValueFormatHelper();

    public Record jsonObject2record(String jsonString) throws IOException {
        Record record;
        ByteArrayInputStream bais = null;
        try {
            Record record2;
            bais = new ByteArrayInputStream(jsonString.getBytes(ENCODING));
            record = record2 = this.jsonStream2record(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return record;
    }

    public Record jsonStream2record(InputStream stream) throws IOException {
        IpcStreamReader reader = this._jsonFactory.newStreamReader(stream);
        try {
            Record record = this.stream2record(reader);
            return record;
        }
        finally {
            reader.closeWithoutStream();
        }
    }

    public Any jsonStream2any(InputStream stream) throws IOException {
        IpcStreamReader reader = this._jsonFactory.newStreamReader(stream);
        try {
            Any any = this.stream2any(reader);
            return any;
        }
        finally {
            reader.closeWithoutStream();
        }
    }

    public Record stream2record(IpcStreamReader reader) throws IOException {
        return this.stream2record(reader, true);
    }

    public Record stream2record(IpcStreamReader reader, boolean required) throws IOException {
        IpcToken token = reader.nextToken();
        if (token != IpcToken.OBJECT_START) {
            if (required) {
                throw new IllegalStateException("Expected OBJECT_START Token; Token = " + token);
            }
            return null;
        }
        token = reader.nextToken();
        if (token != IpcToken.MAPPING_START) {
            throw new IllegalStateException("Expected MAPPING_START Token; Token = " + token);
        }
        AnyMap metadata = this.readMap(reader);
        Record record = this._dataFactory.createRecord();
        record.getMetadata().putAll(metadata);
        token = reader.nextToken();
        if (token != IpcToken.OBJECT_END) {
            throw new IllegalStateException("Expected OBJECT_END Token; Token = " + token);
        }
        return record;
    }

    public Any stream2any(IpcStreamReader reader) throws IOException {
        IpcToken token = reader.nextToken();
        if (token != IpcToken.OBJECT_START) {
            throw new IllegalStateException("Expected OBJECT_START Token; Token = " + token);
        }
        Any any = this.readAny(reader, reader.nextToken());
        token = reader.nextToken();
        if (token != IpcToken.OBJECT_END) {
            throw new IllegalStateException("Expected OBJECT_END Token; Token = " + token);
        }
        return any;
    }

    public String record2JsonObject(Record record) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.record2JsonStream(baos, record);
            String string = baos.toString(ENCODING);
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void record2JsonStream(OutputStream stream, Record record) throws IOException {
        IpcStreamWriter writer = this._jsonFactory.newStreamWriter(stream);
        try {
            this.record2Stream(writer, record);
        }
        finally {
            writer.closeWithoutStream();
        }
    }

    public void map2JsonStream(OutputStream stream, AnyMap object) throws IOException {
        this.any2JsonStream(stream, object);
    }

    public String map2JsonObject(AnyMap object) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.map2JsonStream(baos, object);
            String string = baos.toString(ENCODING);
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void any2JsonStream(OutputStream stream, Any object) throws IOException {
        IpcStreamWriter writer = this._jsonFactory.newStreamWriter(stream);
        try {
            this.any2Stream(writer, object);
        }
        finally {
            writer.closeWithoutStream();
        }
    }

    public void any2Stream(IpcStreamWriter writer, Any object) throws IOException {
        writer.writeObjectStart();
        this.writeAny(writer, object);
        writer.writeObjectEnd();
    }

    public void record2Stream(IpcStreamWriter writer, Record record) throws IOException {
        this.any2Stream(writer, record.getMetadata());
    }

    private AnyMap readMap(IpcStreamReader reader) throws IOException {
        IpcToken token;
        AnyMap map = this._dataFactory.createAnyMap();
        while ((token = reader.nextToken()) != IpcToken.MAPPING_END) {
            if (token != IpcToken.SCALAR_STRING) {
                throw new IllegalStateException("Expected SCALAR_STRING Token; Token = " + token);
            }
            String key = reader.currentStringValue();
            map.put(key, this.readAny(reader, reader.nextToken()));
        }
        return map;
    }

    private AnySeq readSeq(IpcStreamReader reader) throws IOException {
        AnySeq anySeq = this._dataFactory.createAnySeq();
        IpcToken token = null;
        while ((token = reader.nextToken()) != IpcToken.SEQUENCE_END) {
            anySeq.add(this.readAny(reader, token));
        }
        return anySeq;
    }

    private Value readValue(IpcStreamReader reader, IpcToken token) throws IOException {
        Value value = null;
        switch (token) {
            case SCALAR_BOOL: {
                value = this._dataFactory.createBooleanValue(reader.currentBoolValue());
                break;
            }
            case SCALAR_DOUBLE: {
                value = this._dataFactory.createDoubleValue(reader.currentDoubleValue());
                break;
            }
            case SCALAR_INT: {
                value = this._dataFactory.createLongValue(reader.currentLongValue());
                break;
            }
            default: {
                value = this._dataFactory.createStringValue(reader.currentStringValue());
            }
        }
        return value;
    }

    private Any readAny(IpcStreamReader reader, IpcToken token) throws IOException {
        Any any = null;
        switch (token) {
            case MAPPING_START: {
                any = this.readMap(reader);
                break;
            }
            case SEQUENCE_START: {
                any = this.readSeq(reader);
                break;
            }
            default: {
                any = this.readValue(reader, token);
            }
        }
        return any;
    }

    private void writeSeq(IpcStreamWriter writer, AnySeq seq) throws IOException {
        writer.writeSequenceStart();
        for (Any any : seq) {
            this.writeAny(writer, any);
        }
        writer.writeSequenceEnd();
    }

    private void writeMap(IpcStreamWriter writer, AnyMap object) throws IOException {
        if (object != null) {
            writer.writeMappingStart();
            if (!object.isEmpty()) {
                for (String childKey : object.keySet()) {
                    writer.writeMappingKey(childKey);
                    Any any = (Any)object.get(childKey);
                    this.writeAny(writer, any);
                }
            }
            writer.writeMappingEnd();
        }
    }

    private void writeValue(IpcStreamWriter writer, Value value) throws IOException {
        if (value != null) {
            if (value.isBoolean()) {
                writer.writeScalarBoolean(value.asBoolean().booleanValue());
            } else if (value.isDate()) {
                writer.writeScalarString(this._formatHelper.formatDate(value.asDate()));
            } else if (value.isDateTime()) {
                writer.writeScalarString(this._formatHelper.formatDateTime(value.asDateTime()));
            } else if (value.isLong()) {
                writer.writeScalarLong(value.asLong().longValue());
            } else if (value.isDouble()) {
                writer.writeScalarDouble(value.asDouble().doubleValue());
            } else if (value.isString()) {
                writer.writeScalarString(value.asString());
            } else {
                writer.writeScalarString(value.asString());
            }
        }
    }

    private void writeAny(IpcStreamWriter writer, Any object) throws IOException {
        if (object != null) {
            if (object.isMap()) {
                this.writeMap(writer, (AnyMap)object);
            } else if (object.isSeq()) {
                this.writeSeq(writer, (AnySeq)object);
            } else if (object.isValue()) {
                this.writeValue(writer, (Value)object);
            }
        }
    }
}

