/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.listener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smila.connectivity.queue.worker.ListenerRule;
import org.eclipse.smila.connectivity.queue.worker.config.ListenerRuleType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractRule;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.listener.ListenerThread;
import org.eclipse.smila.connectivity.queue.worker.internal.listener.ListenerWorker;
import org.eclipse.smila.connectivity.queue.worker.jms.BrokerConnectionException;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.management.performance.PerformanceCounter;
import org.eclipse.smila.management.performance.PerformanceCounterFormula;

public class ListenerRuleImpl
extends AbstractRule<ListenerRuleType>
implements ListenerRule,
ManagementAgent {
    private final List<ListenerThread> _threads = new ArrayList<ListenerThread>();
    private final String _agentName;
    private final PerformanceCounter _recordsProcessed;
    private final ManagementAgentLocation _location;
    private int _maxMessageBlockSize;

    public ListenerRuleImpl(ServicesAccessPoint accessPoint, ListenerRuleType ruleConfig) throws BrokerConnectionException {
        super(accessPoint, ruleConfig);
        this._agentName = ruleConfig.getName();
        this._recordsProcessed = new PerformanceCounter(PerformanceCounterFormula.SIMPLE_COUNT_FORMULA);
        this._location = ManagementRegistration.INSTANCE.getCategory("QueueWorker").getCategory("Listener").getLocation(this._agentName);
        this._maxMessageBlockSize = ruleConfig.getMaxMessageBlockSize();
        ManagementRegistration.INSTANCE.registerAgent(this._location, (ManagementAgent)this);
        int i = 0;
        while (i < ruleConfig.getThreads()) {
            this.increaseNoOfThreads();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseNoOfThreads() {
        ListenerThread thread;
        List<ListenerThread> list = this._threads;
        synchronized (list) {
            ListenerWorker worker = new ListenerWorker(this, this._accessPoint, (ListenerRuleType)this._ruleConfig, this._threads.size());
            thread = new ListenerThread(worker);
            this._threads.add(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseNoOfThreads() {
        List<ListenerThread> list = this._threads;
        synchronized (list) {
            ListenerThread thread;
            if (this._threads.size() > 0 && (thread = this._threads.remove(this._threads.size() - 1)).isAlive()) {
                thread.stopWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoOfThreads() {
        List<ListenerThread> list = this._threads;
        synchronized (list) {
            return this._threads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoOfThreads(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Threads quantity cannot be negative!");
        }
        List<ListenerThread> list = this._threads;
        synchronized (list) {
            while (this._threads.size() < size) {
                this.increaseNoOfThreads();
            }
            while (this._threads.size() > size) {
                this.decreaseNoOfThreads();
            }
        }
    }

    public PerformanceCounter getNoOfProcessedRecords() {
        return this._recordsProcessed;
    }

    public int getMaxMessageBlockSize() {
        return this._maxMessageBlockSize;
    }

    public void setMaxMessageBlockSize(int size) {
        this._maxMessageBlockSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        List<ListenerThread> list = this._threads;
        synchronized (list) {
            while (this._threads.size() > 0) {
                this.decreaseNoOfThreads();
            }
        }
        ManagementRegistration.INSTANCE.unregisterAgent(this._location);
    }
}

