/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.def.DBoolean;
import org.eclipse.smila.search.utils.param.def.DDate;
import org.eclipse.smila.search.utils.param.def.DEnumeration;
import org.eclipse.smila.search.utils.param.def.DParameter;
import org.eclipse.smila.search.utils.param.def.DParameterDefinition;
import org.eclipse.smila.search.utils.param.def.DParameterDefinitionCodec;
import org.eclipse.smila.search.utils.param.def.DStringList;
import org.eclipse.smila.search.utils.param.set.DDateList;
import org.eclipse.smila.search.utils.param.set.DFloat;
import org.eclipse.smila.search.utils.param.set.DFloatList;
import org.eclipse.smila.search.utils.param.set.DInteger;
import org.eclipse.smila.search.utils.param.set.DIntegerList;
import org.eclipse.smila.search.utils.param.set.DParameterSet;
import org.eclipse.smila.search.utils.param.set.DParameterSetCodec;
import org.eclipse.smila.search.utils.param.set.DString;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterSet {
    private final Hashtable _params = new Hashtable();
    private final Hashtable _types = new Hashtable();

    public ParameterSet(DParameterSet paramSet, DParameterDefinition paramDef) throws ParameterException {
        this.initializeFromDParamSet(paramSet, paramDef);
    }

    public ParameterSet(DParameterSet paramSet) throws ParameterException {
        this.initializeFromDParamSet(paramSet, null);
    }

    public static void main(String[] arg) {
        block7: {
            Log log = LogFactory.getLog(ParameterSet.class);
            try {
                Document d = XMLUtils.parse((File)new File("d:/anyfinder/af-engine-sdk/xml/param-testcase.xml"), (boolean)true);
                DParameterSet pset = DParameterSetCodec.decode(d.getDocumentElement());
                Document d2 = XMLUtils.getDocument((String)"top");
                Element e = d2.getDocumentElement();
                Element pelement = DParameterSetCodec.encode(pset, e);
                XMLUtils.stream((Element)pelement, (boolean)false, (String)"UTF-8", (OutputStream)System.err);
                d = XMLUtils.parse((File)new File("d:/anyfinder/af-engine-sdk/xml/paramdef-testcase.xml"), (boolean)true);
                DParameterDefinition pdef = DParameterDefinitionCodec.decode(d.getDocumentElement());
                d2 = XMLUtils.getDocument((String)"top");
                e = d2.getDocumentElement();
                pelement = DParameterDefinitionCodec.encode(pdef, e);
                XMLUtils.stream((Element)pelement, (boolean)false, (String)"UTF-8", (OutputStream)System.err);
                ParameterSet ps = new ParameterSet(pset, pdef);
                Enumeration en = ps.getParameterNames();
                while (en.hasMoreElements()) {
                    String pname = (String)en.nextElement();
                    String ptype = ps.getParameterType(pname);
                    Object value = ps.getParameter(pname);
                    if (ptype.indexOf("List") >= 0) {
                        String newValue = "";
                        int i = 0;
                        while (true) {
                            try {
                                newValue = String.valueOf(newValue) + Array.get(value, i);
                                Array.get(value, i + 1);
                                newValue = String.valueOf(newValue) + ", ";
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                break;
                            }
                            ++i;
                        }
                        value = newValue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)(String.valueOf(pname) + "(" + ptype + "):\t" + value));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)e);
            }
        }
    }

    private void addParam(String name, Object value) {
        if (value == null) {
            this._params.remove(name);
        } else {
            this._params.put(name, value);
        }
    }

    private boolean checkConsistency(DParameterSet paramSet, DParameterDefinition paramDef) throws ParameterException {
        DParameter[] defs = paramDef.getParameters();
        int i = 0;
        while (i < defs.length) {
            String pname = defs[i].getName();
            this.checkParameter(paramSet, paramSet.getParameter(pname), defs[i]);
            ++i;
        }
        org.eclipse.smila.search.utils.param.set.DParameter[] params = paramSet.getParameters();
        int i2 = 0;
        while (i2 < params.length) {
            if (paramDef.getParameter(params[i2].getName()) == null) {
                throw new ParameterException("Unknown parameter '" + params[i2].getName() + "'");
            }
            ++i2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkParameter(DParameterSet paramSet, org.eclipse.smila.search.utils.param.set.DParameter param, DParameter def) throws ParameterException {
        String defType = def.getType();
        if (param == null) {
            if (!"optional".equals(def.getConstraint())) throw new ParameterException("Required parameter '" + def.getName() + "' not found");
            if (!def.hasDefault()) return true;
            String type = defType;
            if ("Boolean".equals(defType)) {
                param = new org.eclipse.smila.search.utils.param.set.DBoolean();
                ((org.eclipse.smila.search.utils.param.set.DBoolean)param).setValue(((DBoolean)def).getDefault());
            } else if ("String".equals(defType)) {
                param = new DString();
                ((DString)param).setValue(((org.eclipse.smila.search.utils.param.def.DString)def).getDefault());
            } else if ("Float".equals(defType)) {
                param = new DFloat();
                ((DFloat)param).setValue(((org.eclipse.smila.search.utils.param.def.DFloat)def).getDefault());
            } else if ("Integer".equals(defType)) {
                param = new DInteger();
                ((DInteger)param).setValue(((org.eclipse.smila.search.utils.param.def.DInteger)def).getDefault());
            } else if ("Date".equals(defType)) {
                param = new org.eclipse.smila.search.utils.param.set.DDate();
                ((org.eclipse.smila.search.utils.param.set.DDate)param).setValue(((DDate)def).getDefault());
            } else if ("StringList".equals(defType)) {
                param = new org.eclipse.smila.search.utils.param.set.DStringList();
                ((org.eclipse.smila.search.utils.param.set.DStringList)param).addValues(((DStringList)def).getDefaults());
            } else if ("FloatList".equals(defType)) {
                param = new DFloatList();
                ((DFloatList)param).addValues(((org.eclipse.smila.search.utils.param.def.DFloatList)def).getDefaults());
            } else if ("IntegerList".equals(defType)) {
                param = new DIntegerList();
                ((DIntegerList)param).addValues(((org.eclipse.smila.search.utils.param.def.DIntegerList)def).getDefaults());
            } else if ("DateList".equals(defType)) {
                param = new DDateList();
                ((DDateList)param).addValues(((org.eclipse.smila.search.utils.param.def.DDateList)def).getDefaults());
            } else {
                if (!"Enumeration".equals(defType)) return true;
                String[] defaults = ((DEnumeration)def).getDefaults();
                if (((DEnumeration)def).isAllowMultiple()) {
                    param = new org.eclipse.smila.search.utils.param.set.DStringList();
                    ((org.eclipse.smila.search.utils.param.set.DStringList)param).addValues(defaults);
                    type = "StringList";
                } else {
                    param = new DString();
                    if (defaults.length > 1) {
                        throw new ParameterException("Invalid default values for parameter '" + def.getName() + "': Enumeration does not allow multiple values");
                    }
                    ((DString)param).setValue(defaults[0]);
                    type = "String";
                }
            }
            param.setName(def.getName());
            param.setType(type);
            paramSet.addParameter(param);
        }
        String paramType = param.getType();
        boolean typeMatch = false;
        if (paramType.equals(defType)) {
            typeMatch = true;
        } else if (defType.equals("Enumeration")) {
            boolean multiple = ((DEnumeration)def).isAllowMultiple();
            if (!multiple && "String".equals(paramType)) {
                typeMatch = true;
            } else if (multiple && "StringList".equals(paramType)) {
                typeMatch = true;
            }
            if (!typeMatch) {
                defType = multiple ? "StringList" : "String";
            }
        }
        if (!typeMatch) {
            throw new ParameterException("Type mismatch for parameter '" + def.getName() + "': expected " + defType + ", but found " + paramType);
        }
        if (!def.getType().equals("Enumeration")) return true;
        String[] values = "StringList".equals(param.getType()) ? ((org.eclipse.smila.search.utils.param.set.DStringList)param).getValues() : new String[]{((DString)param).getValue()};
        int i = 0;
        while (i < values.length) {
            boolean enumMatch = false;
            String[] defValues = ((DEnumeration)def).getValues();
            int j = 0;
            while (j < defValues.length) {
                if (values[i] != null && values[i].equals(defValues[j])) {
                    enumMatch = true;
                    break;
                }
                ++j;
            }
            if (!enumMatch) {
                String allowedValues = "";
                int j2 = 0;
                while (j2 < defValues.length) {
                    if (!"".equals(allowedValues)) {
                        allowedValues = String.valueOf(allowedValues) + ",";
                    }
                    allowedValues = String.valueOf(allowedValues) + defValues[j2];
                    ++j2;
                }
                throw new ParameterException("Unknown value for parameter " + def.getName() + ": expected [" + allowedValues + "], but found '" + values[i] + "'");
            }
            ++i;
        }
        return true;
    }

    public Boolean getBooleanParameter(String name) {
        Object o = this._params.get(name);
        return (Boolean)o;
    }

    public Date[] getDateListParameter(String name) {
        Object o = this._params.get(name);
        return (Date[])o;
    }

    public Date getDateParameter(String name) {
        Object o = this._params.get(name);
        return (Date)o;
    }

    public float[] getFloatListParameter(String name) {
        Object o = this._params.get(name);
        return (float[])o;
    }

    public Float getFloatParameter(String name) {
        Object o = this._params.get(name);
        return (Float)o;
    }

    public int[] getIntegerListParameter(String name) {
        Object o = this._params.get(name);
        return (int[])o;
    }

    public Integer getIntegerParameter(String name) {
        Object o = this._params.get(name);
        return (Integer)o;
    }

    public Object getParameter(String name) {
        return this._params.get(name);
    }

    public Enumeration getParameterNames() {
        return this._params.keys();
    }

    public String getParameterType(String name) {
        String type = (String)this._types.get(name);
        if (type == null) {
            throw new NullPointerException("Parameter '" + name + "' does not exist");
        }
        return type;
    }

    public String[] getStringListParameter(String name) {
        Object o = this._params.get(name);
        return (String[])o;
    }

    public String getStringParameter(String name) {
        Object o = this._params.get(name);
        return (String)o;
    }

    public boolean hasParameter(String name) {
        return this._params.containsKey(name);
    }

    protected void initializeFromDParamSet(DParameterSet paramSet, DParameterDefinition paramDef) throws ParameterException {
        if (paramDef != null) {
            this.checkConsistency(paramSet, paramDef);
        }
        org.eclipse.smila.search.utils.param.set.DParameter[] params = paramSet.getParameters();
        int i = 0;
        while (i < params.length) {
            org.eclipse.smila.search.utils.param.set.DParameter p = params[i];
            if (p instanceof org.eclipse.smila.search.utils.param.set.DBoolean) {
                this.setBooleanParameter(p.getName(), new Boolean(((org.eclipse.smila.search.utils.param.set.DBoolean)p).getValue()));
            } else if (p instanceof DString) {
                this.setStringParameter(p.getName(), ((DString)p).getValue());
            } else if (p instanceof DInteger) {
                this.setIntegerParameter(p.getName(), new Integer(((DInteger)p).getValue()));
            } else if (p instanceof DFloat) {
                this.setFloatParameter(p.getName(), new Float(((DFloat)p).getValue()));
            } else if (p instanceof org.eclipse.smila.search.utils.param.set.DDate) {
                this.setDateParameter(p.getName(), ((org.eclipse.smila.search.utils.param.set.DDate)p).getValue());
            } else if (p instanceof org.eclipse.smila.search.utils.param.set.DStringList) {
                this.setStringListParameter(p.getName(), ((org.eclipse.smila.search.utils.param.set.DStringList)p).getValues());
            } else if (p instanceof DIntegerList) {
                this.setIntegerListParameter(p.getName(), ((DIntegerList)p).getValues());
            } else if (p instanceof DFloatList) {
                this.setFloatListParameter(p.getName(), ((DFloatList)p).getValues());
            } else if (p instanceof DDateList) {
                this.setDateListParameter(p.getName(), ((DDateList)p).getValues());
            } else {
                throw new ParameterException("Unknown parameter type [" + p.getClass() + "]");
            }
            ++i;
        }
    }

    public void setBooleanParameter(String name, Boolean value) {
        this._types.put(name, "Boolean");
        this.addParam(name, value);
    }

    public void setDateListParameter(String name, Date[] value) {
        this._types.put(name, "DateList");
        this.addParam(name, value);
    }

    public void setDateParameter(String name, Date value) {
        this._types.put(name, "Date");
        this.addParam(name, value);
    }

    public void setFloatListParameter(String name, float[] value) {
        this._types.put(name, "FloatList");
        this.addParam(name, value);
    }

    public void setFloatParameter(String name, float value) {
        this._types.put(name, "Float");
        this.addParam(name, new Float(value));
    }

    public void setFloatParameter(String name, Float value) {
        this._types.put(name, "Float");
        this.addParam(name, value);
    }

    public void setIntegerListParameter(String name, int[] value) {
        this._types.put(name, "IntegerList");
        this.addParam(name, value);
    }

    public void setIntegerParameter(String name, int value) {
        this._types.put(name, "Integer");
        this.addParam(name, new Integer(value));
    }

    public void setIntegerParameter(String name, Integer value) {
        this._types.put(name, "Integer");
        this.addParam(name, value);
    }

    public void setStringListParameter(String name, String[] value) {
        this._types.put(name, "StringList");
        this.addParam(name, value);
    }

    public void setStringParameter(String name, String value) {
        this._types.put(name, "String");
        this.addParam(name, value);
    }
}

