/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search.parameterobjects;

import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.set.DParameterSetCodec;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.parameterobjects.DTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DTransformerCodec {
    public static DTransformer decode(Element element) throws DSearchException {
        DTransformer dTransformer = new DTransformer();
        dTransformer.setName(element.getAttribute("Name"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("ParameterSet".equals(nl.item(i).getLocalName())) {
                try {
                    dTransformer.setParameterSet(DParameterSetCodec.decode((Element)nl.item(i)));
                }
                catch (ParameterException e) {
                    throw new DSearchException("Unable to decode parameters for Transformer: " + e.getMessage(), e);
                }
            }
            ++i;
        }
        return dTransformer;
    }

    public static Element encode(DTransformer dTransformer, Element element) throws DSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/Search/ParameterObjects", "Transformer");
        el.setAttribute("Name", dTransformer.getName());
        try {
            DParameterSetCodec.encode(dTransformer.getParameterSet(), el);
        }
        catch (ParameterException e) {
            throw new DSearchException("Unable to encode parameters for Transformer: " + e.getMessage(), e);
        }
        element.appendChild(el);
        return el;
    }
}

