/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;

public class MockSearchPipelet
implements Pipelet {
    public static final int MAX_TOTAL_HITS = 123;
    public static final int MAX_INDEX_SIZE = 12345;
    public static final String TITLE = "title";
    public static final String PREFIX = "Result #";
    public static final String PREFIX_BLIND = "... Lorem ipsum dolor sit amet, ";
    public static final String SUFFIX_BLIND = ", consectetuer adipiscing elit ... ";
    public static final String PREFIX_HIGHLIGHT = "<b>";
    public static final String SUFFIX_HIGHLIGHT = "</b>";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] message) throws ProcessingException {
        if (message.length > 0) {
            QueryParameterAccessor parameters = new QueryParameterAccessor(blackboard, message[0]);
            parameters.setPipeletConfiguration(this._configuration);
            String query = parameters.getQuery();
            int maxCount = parameters.getMaxCount();
            int offset = parameters.getOffset();
            double threshold = parameters.getThreshold();
            try {
                AnyMap request = blackboard.getMetadata(message[0]);
                DataFactory f = request.getFactory();
                if (query == null || query.trim().length() == 0) {
                    request.put((Object)"records", (Object)f.createAnySeq());
                    request.put((Object)"count", (Object)f.createLongValue(0));
                } else {
                    AnySeq records = f.createAnySeq();
                    int i = 0;
                    while (i < maxCount) {
                        int position = offset + i;
                        String value = PREFIX + position;
                        double relevance = 1.0 - (double)position / 123.0;
                        if (relevance >= threshold) {
                            AnyMap record = f.createAnyMap();
                            record.put((Object)"_recordid", (Object)f.createStringValue("file:file_" + i + ".html"));
                            record.put((Object)"_source", (Object)f.createStringValue("file"));
                            record.put((Object)TITLE, (Object)f.createStringValue(value));
                            record.put((Object)"_weight", (Object)f.createDoubleValue(Double.valueOf(relevance)));
                            this.setRecordHighlighting(f, record, "... Lorem ipsum dolor sit amet, <b>" + query + SUFFIX_HIGHLIGHT + " #" + position + SUFFIX_BLIND, relevance);
                            records.add((Object)record);
                        }
                        ++i;
                    }
                    int totalHits = (int)((1.0 - threshold) * 123.0);
                    request.put((Object)"records", (Object)records);
                    request.put((Object)"count", (Object)f.createLongValue(totalHits));
                    request.put((Object)"indexSize", (Object)f.createLongValue(12345));
                    this.setGroups(f, request, query, totalHits);
                }
            }
            catch (BlackboardAccessException ex) {
                this._log.error((Object)ex);
            }
        }
        return message;
    }

    private void setGroups(DataFactory f, AnyMap result, String text, int totalHits) throws BlackboardAccessException {
        if (text != null) {
            Random rnd = new Random(System.nanoTime());
            String[] tokens = text.split(" ");
            AnySeq groups = f.createAnySeq();
            int i = 0;
            while (i < tokens.length) {
                AnyMap group = f.createAnyMap();
                group.put((Object)"value", (Object)f.createStringValue(tokens[i]));
                int facetCount = i < tokens.length - 1 ? rnd.nextInt(totalHits) : totalHits;
                group.put((Object)"count", (Object)f.createLongValue(facetCount));
                totalHits -= facetCount;
                groups.add((Object)group);
                ++i;
            }
        }
    }

    private void setRecordHighlighting(DataFactory f, AnyMap record, String text, double quality) {
        if (text != null) {
            AnyMap highlight = f.createAnyMap();
            highlight.put((Object)"text", (Object)f.createStringValue(text));
            record.put((Object)"_highlight", (Object)highlight);
        }
    }
}

