/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util;

import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.utils.digest.DigestHelper;

public final class ConnectivityHashFactory {
    private static ConnectivityHashFactory s_instance;

    private ConnectivityHashFactory() {
    }

    public static ConnectivityHashFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ConnectivityHashFactory();
        }
        return s_instance;
    }

    public String createHash(AnyMap hashAttributesMap) {
        if (hashAttributesMap == null || hashAttributesMap.size() == 0) {
            throw new IllegalArgumentException("Parameter hashAttributes must not be null or empty");
        }
        return this.createHash(hashAttributesMap, null);
    }

    public String createHash(Map<String, ?> hashAttachments) {
        if (hashAttachments == null || hashAttachments.isEmpty()) {
            throw new IllegalArgumentException("Parameter hashAttachments must not be null or empty");
        }
        return this.createHash(null, hashAttachments);
    }

    public String createHash(AnyMap hashAttributeMap, Map<String, ?> hashAttachments) {
        if (!(hashAttributeMap != null && hashAttributeMap.size() != 0 || hashAttachments != null && !hashAttachments.isEmpty())) {
            throw new IllegalArgumentException("Parameters hashAttributes and hashAttachments must not both be null or empty");
        }
        StringBuilder buffer = new StringBuilder();
        if (hashAttributeMap != null) {
            for (Map.Entry entry : hashAttributeMap.entrySet()) {
                buffer.append((String)entry.getKey()).append('=').append(((Any)entry.getValue()).toString()).append(';');
            }
        }
        if (hashAttachments != null) {
            for (String attachmentName : hashAttachments.keySet()) {
                Object attachmentValue = hashAttachments.get(attachmentName);
                if (attachmentValue instanceof String) {
                    buffer.append(attachmentName).append('=').append(attachmentValue).append(';');
                    continue;
                }
                if (attachmentValue instanceof byte[]) {
                    buffer.append(attachmentName).append('=').append(DigestHelper.calculateDigest((byte[])((byte[])attachmentValue))).append(';');
                    continue;
                }
                throw new IllegalArgumentException("Attachments must be of type String or byte[]");
            }
        }
        return DigestHelper.calculateDigest((String)buffer.toString());
    }

    public String createHash(String value) {
        return DigestHelper.calculateDigest((String)value);
    }
}

