/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;

public class SubAttributeExtractorPipelet
implements Pipelet {
    public static final String PROPPERTY_INPUT_PATH = "inputPath";
    public static final String PROPPERTY_OUTPUT_PATH = "outputPath";
    public static final String PROPPERTY_MODE = "mode";
    public static final String PROPPERTY_SEPARATOR = "separator";
    public static final String DEFAULT_SEPARATOR = " ";
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private final Log _log = LogFactory.getLog(SubAttributeExtractorPipelet.class);
    private String _inputPath;
    private String[] _inputPathNames;
    private String _outputPath;
    private Mode _mode;
    private String _separator;
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
        ParameterAccessor parameters = new ParameterAccessor(this._configuration);
        this._inputPath = parameters.getRequiredParameter(PROPPERTY_INPUT_PATH);
        this._inputPathNames = this._inputPath.split(DEFAULT_PATH_SEPARATOR);
        this._outputPath = parameters.getRequiredParameter(PROPPERTY_OUTPUT_PATH);
        this._mode = Mode.valueOf(parameters.getRequiredParameter(PROPPERTY_MODE));
        this._separator = parameters.getParameter(PROPPERTY_SEPARATOR, DEFAULT_SEPARATOR);
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    AnyMap metadata = blackboard.getMetadata(id);
                    Any any = this.getValues(metadata);
                    if (any != null) {
                        this.setValues(metadata, id, any);
                    }
                }
                catch (Exception e) {
                    this._log.error((Object)("Error while processing record " + id), (Throwable)e);
                }
                ++n2;
            }
        }
        return recordIds;
    }

    public String getInputPath() {
        return this._inputPath;
    }

    public String getOutputPath() {
        return this._outputPath;
    }

    public Mode getMode() {
        return this._mode;
    }

    public String getSeparator() {
        return this._separator;
    }

    private Any getValues(AnyMap metadata) {
        AnyMap current = metadata;
        int lastIndex = this._inputPathNames.length - 1;
        int i = 0;
        while (i < lastIndex) {
            Any element = (Any)current.get((Object)this._inputPathNames[i]);
            if (element.isSeq() && !element.isEmpty()) {
                element = (Any)((AnySeq)element).get(0);
            }
            if (!element.isMap()) {
                return null;
            }
            current = (AnyMap)element;
            ++i;
        }
        return (Any)current.get((Object)this._inputPathNames[lastIndex]);
    }

    private void setValues(AnyMap metaData, String id, Any any) throws BlackboardAccessException {
        AnySeq values = metaData.getFactory().createAnySeq();
        for (Any a : any) {
            if (!a.isValue()) continue;
            values.add((Object)a);
        }
        if (values != null && !values.isEmpty()) {
            switch (this._mode) {
                case FIRST: {
                    metaData.put((Object)this._outputPath, (Object)((Any)values.get(0)));
                    break;
                }
                case LAST: {
                    metaData.put((Object)this._outputPath, (Object)((Any)values.get(values.size() - 1)));
                    break;
                }
                case ALL_AS_LIST: {
                    metaData.put((Object)this._outputPath, (Object)values);
                    break;
                }
                case ALL_AS_ONE: {
                    metaData.put((Object)this._outputPath, (Object)this.concat(values, metaData.getFactory()));
                    break;
                }
                default: {
                    this._log.error((Object)("Error while processing record " + id + ". Invalid mode " + (Object)((Object)this._mode)));
                }
            }
        }
    }

    private Value concat(AnySeq values, DataFactory factory) {
        StringBuffer buffer = new StringBuffer();
        for (Any any : values) {
            String stringValue = ((Value)any).asString();
            if (buffer.length() > 0) {
                buffer.append(this._separator);
            }
            buffer.append(stringValue);
        }
        return factory.createStringValue(buffer.toString());
    }

    private static enum Mode {
        FIRST,
        LAST,
        ALL_AS_LIST,
        ALL_AS_ONE;

    }
}

