/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DHighlightingTransformer;
import org.eclipse.smila.search.highlighting.HighlightingService;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.set.DBoolean;
import org.eclipse.smila.search.utils.param.set.DInteger;
import org.eclipse.smila.search.utils.param.set.DParameter;
import org.eclipse.smila.search.utils.param.set.DParameterSet;
import org.eclipse.smila.search.utils.param.set.DString;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class HighlightingServiceImpl
implements HighlightingService {
    public static final String HIGHLIGHTING_TRANSFORMER_REFERENCE = "highlightingTransformer";
    public static final String PROPERTY_HIGHLIGHTING_TRANSFORMER_TYPE = "smila.highlighting.transformer.type";
    private final Log _log = LogFactory.getLog(HighlightingService.class);
    private ComponentContext _componentContext;
    private HashMap<String, ServiceReference> _highlightingTransformer;

    protected void activate(ComponentContext context) throws Exception {
        this._componentContext = context;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"activating HighlightingService");
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (this._highlightingTransformer != null) {
            this._highlightingTransformer.clear();
            this._highlightingTransformer = null;
        }
        this._componentContext = null;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"deactivating HighlightingService");
        }
    }

    protected void setHighlightingTransformer(ServiceReference serviceReference) {
        if (this._highlightingTransformer == null) {
            this._highlightingTransformer = new HashMap();
        }
        if (serviceReference != null) {
            String type = serviceReference.getProperty(PROPERTY_HIGHLIGHTING_TRANSFORMER_TYPE).toString();
            if (type == null) {
                this._log.error((Object)"Cannot use highlighting transformer without property smila.highlighting.transformer.type");
            } else {
                this._highlightingTransformer.put(type, serviceReference);
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Registered highlighting transformer " + type));
                }
            }
        }
    }

    protected void unsetHighlightingTransformer(ServiceReference serviceReference) {
        String type;
        if (this._highlightingTransformer != null && serviceReference != null && (type = serviceReference.getProperty(PROPERTY_HIGHLIGHTING_TRANSFORMER_TYPE).toString()) != null) {
            this._highlightingTransformer.remove(type);
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Unregistered highlighting transformer " + type));
            }
        }
    }

    @Override
    public Map<String, DHighlightingTransformer> getTransformerConfigs(QueryParameterAccessor parameters) throws BlackboardAccessException {
        AnyMap transformerConfigs;
        HashMap<String, DHighlightingTransformer> highlightConfigs = new HashMap<String, DHighlightingTransformer>();
        List attributeNames = parameters.getHighlightAttributeNames();
        if (attributeNames != null && (transformerConfigs = parameters.getSubParameter("highlightingTransformers")) != null) {
            for (String attributeName : attributeNames) {
                DHighlightingTransformer highlightConfig;
                AnyMap attributeConfig = transformerConfigs.getMap(attributeName);
                if (attributeConfig == null || (highlightConfig = this.createHighlightConfig(attributeConfig)) == null) continue;
                highlightConfigs.put(attributeName, highlightConfig);
            }
        }
        return highlightConfigs;
    }

    @Override
    public void highlight(AnyMap resultRecord, Map<String, DHighlightingTransformer> highlightConfigs) throws BlackboardAccessException, HighlightingTransformerException, ParameterException {
        Any highlights;
        if (resultRecord.containsKey((Object)"_highlight") && (highlights = (Any)resultRecord.get((Object)"_highlight")).isMap() && !highlights.isEmpty()) {
            AnyMap highlightsMap = (AnyMap)highlights;
            for (String attributeName : highlightConfigs.keySet()) {
                if (!highlightsMap.containsKey((Object)attributeName)) continue;
                DHighlightingTransformer highlightConfig = highlightConfigs.get(attributeName);
                Any highlight = (Any)highlightsMap.get((Object)attributeName);
                if (!highlight.isMap() || highlight.isEmpty()) continue;
                HighlightingTransformer transformer = null;
                if (this._highlightingTransformer != null) {
                    transformer = (HighlightingTransformer)this._componentContext.locateService(HIGHLIGHTING_TRANSFORMER_REFERENCE, this._highlightingTransformer.get(highlightConfig.getName()));
                }
                if (transformer != null) {
                    highlightsMap.put((Object)attributeName, (Object)transformer.transform((AnyMap)highlight, highlightConfig.getParameterSet()));
                    continue;
                }
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)("Could not find a HighlightingTransformer with name " + highlightConfig.getName()));
            }
        }
    }

    private DHighlightingTransformer createHighlightConfig(AnyMap attributeConfig) {
        if (attributeConfig.containsKey((Object)"name")) {
            DHighlightingTransformer config = new DHighlightingTransformer();
            config.setName(attributeConfig.getStringValue("name"));
            DParameterSet parameterSet = this.createParameterSet(attributeConfig);
            config.setParameterSet(parameterSet);
            return config;
        }
        return null;
    }

    private DParameterSet createParameterSet(AnyMap highlightingTransformer) {
        DParameterSet parameterSet = new DParameterSet();
        for (String paramName : highlightingTransformer.keySet()) {
            if ("name".equals(paramName)) continue;
            String value = highlightingTransformer.getStringValue(paramName);
            if ("MarkupPrefix".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("MarkupSuffix".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("MaxLength".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("MaxHLElements".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("MaxPrecedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("MaxSucceedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("PrecedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("SucceedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("SortAlgorithm".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("TextHandling".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("HLElementFilter".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDBoolean(paramName, Boolean.parseBoolean(value)));
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("unknown HighlightingTransformer parameter name " + paramName));
        }
        return parameterSet;
    }

    private DInteger createDInteger(String name, int value) {
        DInteger param = new DInteger();
        param.setName(name);
        param.setType("Integer");
        param.setValue(value);
        return param;
    }

    private DString createDString(String name, String value) {
        DString param = new DString();
        param.setName(name);
        param.setType("String");
        param.setValue(value);
        return param;
    }

    private DBoolean createDBoolean(String name, boolean value) {
        DBoolean param = new DBoolean();
        param.setName(name);
        param.setType("Boolean");
        param.setValue(value);
        return param;
    }
}

