/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smila.utils.conversion.DefaultConversionUtils;

public class ErrorsBuffer {
    private static final String SEPARATOR = "--- %s ---\n";
    private static final String CRITICAL_EXCEPTION_SEPARATOR = "--- %s Critical exception! ---\n";
    private static final int DEFAULT_CAPACITY = 10;
    private final List<String> _errors = new CopyOnWriteArrayList<String>();
    private final int _capacity;

    public ErrorsBuffer() {
        this(10);
    }

    public ErrorsBuffer(int capacity) {
        this._capacity = capacity;
    }

    public void addError(Throwable exception) {
        this.addError(exception, false);
    }

    public void addCriticalError(Throwable exception) {
        this.addError(exception, true);
    }

    public void addError(Throwable exception, boolean isCritical) {
        this._errors.add(this.getStackTrace(exception, isCritical));
        if (this._errors.size() > this._capacity) {
            this._errors.remove(0);
        }
    }

    public List<String> getErrors() {
        return this._errors;
    }

    private String getStackTrace(Throwable exception, boolean isCritical) {
        StringWriter stackTrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTrace);
        String dateString = DefaultConversionUtils.convert((Object)new Date());
        if (isCritical) {
            printWriter.append(String.format(CRITICAL_EXCEPTION_SEPARATOR, dateString));
        } else {
            printWriter.append(String.format(SEPARATOR, dateString));
        }
        exception.printStackTrace(printWriter);
        printWriter.close();
        return ((Object)stackTrace).toString();
    }
}

