/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jms;

import java.io.Reader;
import java.io.StringReader;
import javax.jms.InvalidSelectorException;
import javax.jms.Message;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.jms.MessageSelectorEvalException;

public class MessageSelectorEvalHelper {
    private final BooleanExpression _booleanExpression;

    public MessageSelectorEvalHelper(String expression) throws MessageSelectorEvalException {
        if (StringUtils.isBlank((String)expression)) {
            this._booleanExpression = null;
            return;
        }
        SelectorParser parser = new SelectorParser((Reader)new StringReader(""));
        try {
            this._booleanExpression = parser.parse(expression);
        }
        catch (InvalidSelectorException e) {
            throw new MessageSelectorEvalException(e);
        }
    }

    public static Message createDummyMessage() {
        return new ActiveMQBytesMessage();
    }

    public boolean evaluate(Message message) throws MessageSelectorEvalException {
        if (this._booleanExpression == null) {
            return true;
        }
        try {
            MessageEvaluationContext context = new MessageEvaluationContext();
            context.setMessageReference((MessageReference)message);
            return (Boolean)this._booleanExpression.evaluate(context);
        }
        catch (Throwable e) {
            throw new MessageSelectorEvalException(e);
        }
    }
}

