/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework;

import java.util.Dictionary;
import org.eclipse.smila.connectivity.framework.Agent;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.AgentControllerCallback;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.osgi.service.component.ComponentContext;

public abstract class AbstractAgent
implements Agent {
    private String _agentId;
    private AgentControllerCallback _controllerCallback;
    private DataSourceConnectionConfig _config;
    private String _sessionId;
    private boolean _stopThread;
    private Thread _agentThread;
    private AgentState _agentState;

    @Override
    public String getAgentId() throws AgentException {
        return this._agentId;
    }

    public AgentState getAgentState() {
        return this._agentState;
    }

    @Override
    public void start(AgentControllerCallback controllerCallback, AgentState agentState, DataSourceConnectionConfig config, String sessionId) throws AgentException {
        if (controllerCallback == null) {
            throw new AgentException("parameter controllerCallback is null");
        }
        if (config == null) {
            throw new AgentException("parameter config is null");
        }
        this._stopThread = false;
        this._controllerCallback = controllerCallback;
        this._config = config;
        this._sessionId = sessionId;
        this._agentState = agentState;
        this._agentState.setDataSourceId(config.getDataSourceID());
        this._agentState.setState(AgentThreadState.Running);
        this._agentState.setStartTime(System.currentTimeMillis());
        this.initialize();
        this._agentThread = new Thread(this);
        this._agentThread.start();
    }

    @Override
    public void stop() throws AgentException {
        this.stopThread();
        this._agentState.setState(AgentThreadState.Stopped);
    }

    protected boolean isStopThread() {
        return this._stopThread;
    }

    protected void stopThread() {
        this._agentState.setEndTime(System.currentTimeMillis());
        this._stopThread = true;
        this._agentThread = null;
        this._controllerCallback.unregister(this._sessionId, this._config.getDeltaIndexing(), this._config.getDataSourceID());
    }

    protected final AgentControllerCallback getControllerCallback() {
        return this._controllerCallback;
    }

    protected final DataSourceConnectionConfig getConfig() {
        return this._config;
    }

    protected final String getSessionId() {
        return this._sessionId;
    }

    protected void activate(ComponentContext context) {
        Dictionary dictionary = context.getProperties();
        this._agentId = (String)dictionary.get("component.name");
    }

    protected void deactivate(ComponentContext context) {
        this._agentId = null;
    }

    protected abstract void initialize() throws AgentException;
}

