/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.bdi.breaks.ActivityBreakpoint;
import org.apache.ode.bpel.bdi.breaks.Breakpoint;
import org.apache.ode.bpel.bdi.breaks.VariableModificationBreakpoint;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.pmapi.BpelManagementFacade;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.InstanceNotFoundException;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.bpel.pmapi.TInstanceInfo;
import org.apache.ode.bpel.runtime.breaks.ActivityBreakpointImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.uuid.UUIDGen;
import org.w3c.dom.Node;

public class BpelManagementFacadeImpl
extends ProcessAndInstanceManagementImpl
implements BpelManagementFacade {
    private static UUIDGen _uuidGen = new UUIDGen();

    public BpelManagementFacadeImpl(BpelServer bpelServer, ProcessStore processStore) {
        super(bpelServer, processStore);
    }

    public short getState(final Long l) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<Short>(){

            @Override
            public Short run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                return processInstanceDAO.getState();
            }
        });
    }

    public Long getProcessInstance(String string, final CorrelationKey correlationKey) throws ManagementException {
        BpelProcessDatabase bpelProcessDatabase = this._db.getProcessDb(QName.valueOf(string));
        bpelProcessDatabase.getClass();
        return this.dbexec(new BpelProcessDatabase.Callable<Long>(bpelProcessDatabase){

            @Override
            public Long run(BpelDAOConnection bpelDAOConnection) throws Exception {
                Iterator iterator = this.getProcessDAO().findInstance(correlationKey).iterator();
                return iterator.hasNext() ? ((ProcessInstanceDAO)iterator.next()).getInstanceId() : null;
            }
        });
    }

    public EventInfoListDocument getEvents(Long l, int n, int n2) throws ManagementException {
        List<String> list;
        try {
            list = this.getEventTimeline("iid=" + l, null);
        }
        catch (Exception exception) {
            throw new ManagementException("Unable to retrieve timeline.", (Throwable)exception);
        }
        if (n >= list.size()) {
            return EventInfoListDocument.Factory.newInstance();
        }
        list = list.subList(n, Math.min(list.size(), n + n2));
        String string = list.get(0);
        String string2 = list.get(list.size() - 1);
        return this.listEvents("iid=" + l, "timestamp>=" + string + " " + "timestamp<=" + string2, 0);
    }

    public int getEventCount(Long l) throws ManagementException {
        TInstanceInfo.EventInfo eventInfo = this.getInstanceInfo(l).getInstanceInfo().getEventInfo();
        if (eventInfo == null) {
            return 0;
        }
        return eventInfo.getCount();
    }

    public String getVariable(final Long l, final Long l2, final String string) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<String>(){

            @Override
            public String run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new ManagementException("InstanceNotFound:" + l);
                }
                ScopeDAO scopeDAO = processInstanceDAO.getScope(l2);
                if (scopeDAO == null) {
                    throw new ManagementException("ScopeNotFound:" + l2);
                }
                XmlDataDAO xmlDataDAO = scopeDAO.getVariable(string);
                if (xmlDataDAO == null) {
                    throw new ManagementException("VarNotFound:" + string);
                }
                return BpelManagementFacadeImpl.nodeToString(xmlDataDAO);
            }
        });
    }

    public Long[] getScopeInstancesForScope(final Long l, final String string) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<Long[]>(){

            @Override
            public Long[] run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new ManagementException("InstanceNotFound:" + l);
                }
                Collection collection = processInstanceDAO.getScopes(string);
                ArrayList<Long> arrayList = new ArrayList<Long>(collection.size());
                for (ScopeDAO scopeDAO : collection) {
                    arrayList.add(scopeDAO.getScopeInstanceId());
                }
                return arrayList.toArray(new Long[collection.size()]);
            }
        });
    }

    public void setVariable(Long l, Long l2, String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void setCorrelation(final Long l, Long l2, final String string, final QName[] qNameArray, final CorrelationKey correlationKey) throws ManagementException {
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new ManagementException("InstanceNotFound:" + l);
                }
                CorrelationSetDAO correlationSetDAO = processInstanceDAO.getCorrelationSet(string);
                correlationSetDAO.setValue(qNameArray, correlationKey);
                return null;
            }
        });
    }

    public CorrelationKey getCorrelation(final Long l, final Long l2, final String string) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<CorrelationKey>(){

            @Override
            public CorrelationKey run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new ManagementException("InstanceNotFound:" + l);
                }
                CorrelationSetDAO correlationSetDAO = BpelManagementFacadeImpl.this.findCorrelationSetDAO(processInstanceDAO, l2, string);
                return correlationSetDAO.getValue();
            }
        });
    }

    public void step(Long l) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(l);
        assert (debuggerSupport != null) : "getDebugger(Long) returned NULL!";
        debuggerSupport.step(l);
    }

    public QName getCompletedFault(final Long l) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<QName>(){

            @Override
            public QName run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new ManagementException("InstanceNotFound:" + l);
                }
                return processInstanceDAO.getFault().getName();
            }
        });
    }

    public Breakpoint[] getGlobalBreakpoints(String string) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(QName.valueOf(string));
        return debuggerSupport.getGlobalBreakpoints();
    }

    public Breakpoint[] getBreakpoints(Long l) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(l);
        return debuggerSupport.getBreakpoints(l);
    }

    public void removeGlobalBreakpoint(String string, Breakpoint breakpoint) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(QName.valueOf(string));
        debuggerSupport.removeGlobalBreakpoint(breakpoint);
    }

    public void removeBreakpoint(Long l, Breakpoint breakpoint) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(l);
        debuggerSupport.removeBreakpoint(l, breakpoint);
    }

    public ActivityBreakpoint addGlobalActivityBreakpoint(String string, String string2) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(QName.valueOf(string));
        ActivityBreakpointImpl activityBreakpointImpl = new ActivityBreakpointImpl(_uuidGen.nextUUID(), string2);
        debuggerSupport.addGlobalBreakpoint(activityBreakpointImpl);
        return activityBreakpointImpl;
    }

    public ActivityBreakpoint addActivityBreakpoint(Long l, String string) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(l);
        ActivityBreakpointImpl activityBreakpointImpl = new ActivityBreakpointImpl(_uuidGen.nextUUID(), string);
        debuggerSupport.addBreakpoint(l, activityBreakpointImpl);
        return activityBreakpointImpl;
    }

    public VariableModificationBreakpoint addVariableModificationBreakpoint(Long l, String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public Date getStartTime(final Long l) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<Date>(){

            @Override
            public Date run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new InstanceNotFoundException("InstanceNotFound:" + l);
                }
                return processInstanceDAO.getCreateTime();
            }
        });
    }

    private CorrelationSetDAO findCorrelationSetDAO(ProcessInstanceDAO processInstanceDAO, Long l, String string) throws ManagementException {
        ScopeDAO scopeDAO = processInstanceDAO.getScope(l);
        CorrelationSetDAO correlationSetDAO = null;
        while ((correlationSetDAO = scopeDAO.getCorrelationSet(string)) == null && (scopeDAO = scopeDAO.getParentScope()) != null) {
        }
        if (correlationSetDAO == null) {
            throw new ManagementException("CorrelationSetNotFound:" + string);
        }
        return correlationSetDAO;
    }

    private static String nodeToString(XmlDataDAO xmlDataDAO) {
        Node node = xmlDataDAO.get();
        String string = node == null ? null : (node.getNodeType() == 1 ? DOMUtils.domToString((Node)node) : node.getNodeValue());
        return string;
    }
}

