/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param.def;

import java.text.ParseException;
import java.util.Date;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.def.DDate;
import org.eclipse.smila.search.utils.param.def.DParameter;
import org.eclipse.smila.search.utils.param.def.DParameterCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DDateCodec {
    private DDateCodec() {
    }

    public static DParameter decode(Element element) throws ParameterException {
        DDate dParameter = new DDate();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            Node textElement = node.getFirstChild();
            String text = null;
            if (textElement != null) {
                text = textElement.getNodeValue();
            }
            if ("Default".equals(node.getLocalName())) {
                try {
                    dParameter.setDefault(XMLUtils.decodeDate((String)text));
                }
                catch (ParseException parseException) {
                    throw new ParameterException("Illegal date format. Must be yyyy-MM-dd [" + text + "]");
                }
            }
            ++i;
        }
        return dParameter;
    }

    public static Element encode(DDate dParameter, Element element) throws ParameterException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Parameter");
        DParameterCodec.encodeStandardValues(dParameter, el, doc);
        if (dParameter.hasDefault()) {
            String value = XMLUtils.encodeDate((Date)dParameter.getDefault());
            Element e = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Default");
            e.appendChild(doc.createTextNode(value));
            el.appendChild(e);
        }
        element.appendChild(el);
        return el;
    }
}

