/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param.def;

import java.text.ParseException;
import java.util.Date;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.def.DDateList;
import org.eclipse.smila.search.utils.param.def.DParameter;
import org.eclipse.smila.search.utils.param.def.DParameterCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DDateListCodec {
    private DDateListCodec() {
    }

    public static DParameter decode(Element element) throws ParameterException {
        DDateList dParameter = new DDateList();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            Node textElement = node.getFirstChild();
            String text = null;
            if (textElement != null) {
                text = textElement.getNodeValue();
            }
            if ("Default".equals(node.getLocalName())) {
                try {
                    dParameter.addDefault(XMLUtils.decodeDate((String)text));
                }
                catch (ParseException parseException) {
                    throw new ParameterException("Illegal date format. Must be yyyy-MM-dd [" + text + "]");
                }
            }
            ++i;
        }
        return dParameter;
    }

    public static Element encode(DDateList dParameter, Element element) throws ParameterException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Parameter");
        DParameterCodec.encodeStandardValues(dParameter, el, doc);
        if (dParameter.hasDefault()) {
            Date[] values = dParameter.getDefaults();
            int i = 0;
            while (i < values.length) {
                Date value = values[i];
                Element e = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Default");
                e.appendChild(doc.createTextNode(XMLUtils.encodeDate((Date)value)));
                el.appendChild(e);
                ++i;
            }
        }
        element.appendChild(el);
        return el;
    }
}

