/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param.def;

import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.def.DBoolean;
import org.eclipse.smila.search.utils.param.def.DBooleanCodec;
import org.eclipse.smila.search.utils.param.def.DDate;
import org.eclipse.smila.search.utils.param.def.DDateCodec;
import org.eclipse.smila.search.utils.param.def.DDateList;
import org.eclipse.smila.search.utils.param.def.DDateListCodec;
import org.eclipse.smila.search.utils.param.def.DEnumeration;
import org.eclipse.smila.search.utils.param.def.DEnumerationCodec;
import org.eclipse.smila.search.utils.param.def.DFloat;
import org.eclipse.smila.search.utils.param.def.DFloatCodec;
import org.eclipse.smila.search.utils.param.def.DFloatList;
import org.eclipse.smila.search.utils.param.def.DFloatListCodec;
import org.eclipse.smila.search.utils.param.def.DInteger;
import org.eclipse.smila.search.utils.param.def.DIntegerCodec;
import org.eclipse.smila.search.utils.param.def.DIntegerList;
import org.eclipse.smila.search.utils.param.def.DIntegerListCodec;
import org.eclipse.smila.search.utils.param.def.DParameter;
import org.eclipse.smila.search.utils.param.def.DString;
import org.eclipse.smila.search.utils.param.def.DStringCodec;
import org.eclipse.smila.search.utils.param.def.DStringList;
import org.eclipse.smila.search.utils.param.def.DStringListCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DParameterCodec {
    private DParameterCodec() {
    }

    public static DParameter decode(Element element) throws ParameterException {
        String type = element.getAttribute("xsi:type");
        type = XMLUtils.getLocalPart((String)type);
        DParameter dParameter = null;
        if ("Float".equals(type)) {
            dParameter = DFloatCodec.decode(element);
        } else if ("Date".equals(type)) {
            dParameter = DDateCodec.decode(element);
        } else if ("String".equals(type)) {
            dParameter = DStringCodec.decode(element);
        } else if ("Integer".equals(type)) {
            dParameter = DIntegerCodec.decode(element);
        } else if ("Boolean".equals(type)) {
            dParameter = DBooleanCodec.decode(element);
        } else if ("FloatList".equals(type)) {
            dParameter = DFloatListCodec.decode(element);
        } else if ("DateList".equals(type)) {
            dParameter = DDateListCodec.decode(element);
        } else if ("StringList".equals(type)) {
            dParameter = DStringListCodec.decode(element);
        } else if ("IntegerList".equals(type)) {
            dParameter = DIntegerListCodec.decode(element);
        } else if ("Enumeration".equals(type)) {
            dParameter = DEnumerationCodec.decode(element);
        } else {
            throw new ParameterException("Unknown parameter type [" + type + "]");
        }
        dParameter.setName(element.getAttribute("Name"));
        dParameter.setConstraint(element.getAttribute("Constraint"));
        dParameter.setType(type);
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            Node textElement = node.getFirstChild();
            String text = null;
            if (textElement != null) {
                text = textElement.getNodeValue();
            }
            if ("Description".equals(node.getLocalName())) {
                dParameter.setDescription(text);
            }
            ++i;
        }
        return dParameter;
    }

    public static Element encode(DParameter dParameter, Element element) throws ParameterException {
        Element el = null;
        if (dParameter instanceof DFloat) {
            el = DFloatCodec.encode((DFloat)dParameter, element);
        } else if (dParameter instanceof DDate) {
            el = DDateCodec.encode((DDate)dParameter, element);
        } else if (dParameter instanceof DString) {
            el = DStringCodec.encode((DString)dParameter, element);
        } else if (dParameter instanceof DInteger) {
            el = DIntegerCodec.encode((DInteger)dParameter, element);
        } else if (dParameter instanceof DBoolean) {
            el = DBooleanCodec.encode((DBoolean)dParameter, element);
        } else if (dParameter instanceof DFloatList) {
            el = DFloatListCodec.encode((DFloatList)dParameter, element);
        } else if (dParameter instanceof DDateList) {
            el = DDateListCodec.encode((DDateList)dParameter, element);
        } else if (dParameter instanceof DStringList) {
            el = DStringListCodec.encode((DStringList)dParameter, element);
        } else if (dParameter instanceof DIntegerList) {
            el = DIntegerListCodec.encode((DIntegerList)dParameter, element);
        } else if (dParameter instanceof DEnumeration) {
            el = DEnumerationCodec.encode((DEnumeration)dParameter, element);
        } else {
            throw new ParameterException("Unknown parameter type [" + dParameter.getClass() + "]");
        }
        el.setAttribute("Name", dParameter.getName());
        el.setAttribute("xsi:type", dParameter.getType());
        if (dParameter.getConstraint() != null) {
            el.setAttribute("Constraint", dParameter.getConstraint());
        }
        element.appendChild(el);
        return el;
    }

    public static void encodeStandardValues(DParameter dParameter, Element el, Document doc) {
        Element eDescription = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Description");
        eDescription.appendChild(doc.createTextNode(dParameter.getDescription()));
        el.appendChild(eDescription);
    }
}

