/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.smila.search.utils.search.DFieldCodec;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.INFParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DNumberFieldCodec {
    protected static DNumberField decode(Element element) throws DSearchException {
        DNumberField dNumberField = new DNumberField();
        DFieldCodec.decodeStandardValues(dNumberField, element);
        dNumberField.setMin(Long.decode(element.getAttribute("Minimum")));
        dNumberField.setMax(Long.decode(element.getAttribute("Maximum")));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Parameter".equals(nl.item(i).getLocalName())) {
                dNumberField.setParameter((INFParameter)DFieldCodec.getParameter((Element)nl.item(i)));
            }
            ++i;
        }
        return dNumberField;
    }

    protected static Element encode(DNumberField dNumberField, Element element) throws DSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/Search", "Field");
        el.setAttribute("xsi:type", "FTNumber");
        DFieldCodec.encodeStandardValues(dNumberField, el);
        if (dNumberField.getMin() == null) {
            throw new DSearchException("minimum value not defined in number field");
        }
        el.setAttribute("Minimum", dNumberField.getMin().toString());
        if (dNumberField.getMax() == null) {
            throw new DSearchException("maximum value not defined in number field");
        }
        el.setAttribute("Maximum", dNumberField.getMax().toString());
        if (dNumberField.getParameter() != null) {
            Class encoder = dNumberField.getParameter().getCodecClass();
            Method m = null;
            if (encoder != null) {
                try {
                    m = encoder.getMethod("encode", INFParameter.class, Element.class);
                }
                catch (NoSuchMethodException e) {
                    throw new DSearchException("unable to locate encoder method", e);
                }
                try {
                    m.invoke(null, dNumberField.getParameter(), el);
                }
                catch (InvocationTargetException e) {
                    throw new DSearchException("unable to invoke encoder method", e);
                }
                catch (IllegalAccessException e) {
                    throw new DSearchException("unable to invoke encoder method", e);
                }
            }
        }
        element.appendChild(el);
        return el;
    }
}

