/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.EventDrivenPollingConsumer;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultEndpoint<E extends Exchange>
implements Endpoint<E>,
CamelContextAware {
    private String endpointUri;
    private CamelContext camelContext;
    private Component component;
    private ScheduledExecutorService executorService;
    private ExchangePattern exchangePattern = ExchangePattern.InOnly;

    protected DefaultEndpoint(String endpointUri, Component component) {
        this(endpointUri, component.getCamelContext());
        this.component = component;
    }

    protected DefaultEndpoint(String endpointUri, CamelContext camelContext) {
        this(endpointUri);
        this.camelContext = camelContext;
    }

    protected DefaultEndpoint(String endpointUri) {
        this.setEndpointUri(endpointUri);
    }

    protected DefaultEndpoint() {
    }

    public int hashCode() {
        return this.getEndpointUri().hashCode() * 37 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultEndpoint) {
            DefaultEndpoint that = (DefaultEndpoint)object;
            return ObjectHelper.equal(this.getEndpointUri(), that.getEndpointUri());
        }
        return false;
    }

    public String toString() {
        return "Endpoint[" + this.getEndpointUri() + "]";
    }

    @Override
    public String getEndpointUri() {
        if (this.endpointUri == null) {
            this.endpointUri = this.createEndpointUri();
            if (this.endpointUri == null) {
                throw new IllegalArgumentException("endpointUri is not specified and " + this.getClass().getName() + " does not implement createEndpointUri() to create a default value");
            }
        }
        return this.endpointUri;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public synchronized ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            Component c = this.getComponent();
            if (c != null && c instanceof DefaultComponent) {
                DefaultComponent dc = (DefaultComponent)c;
                this.executorService = dc.getExecutorService();
            }
            if (this.executorService == null) {
                this.executorService = this.createExecutorService();
            }
        }
        return this.executorService;
    }

    public synchronized void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public PollingConsumer<E> createPollingConsumer() throws Exception {
        return new EventDrivenPollingConsumer(this);
    }

    public E convertTo(Class<E> type, Exchange exchange) {
        if (type.isInstance(exchange)) {
            return (E)((Exchange)type.cast(exchange));
        }
        return (E)((Exchange)this.getCamelContext().getExchangeConverter().convertTo(type, exchange));
    }

    @Override
    public E createExchange(Exchange exchange) {
        Class<E> exchangeType = this.getExchangeType();
        if (exchangeType != null && exchangeType.isInstance(exchange)) {
            return (E)((Exchange)exchangeType.cast(exchange));
        }
        E answer = this.createExchange();
        answer.copyFrom(exchange);
        return answer;
    }

    public Class<E> getExchangeType() {
        Type argumentType;
        ParameterizedType parameterizedType;
        Type[] arguments;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (argumentType = arguments[0]) instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    @Override
    public E createExchange() {
        return this.createExchange(this.getExchangePattern());
    }

    @Override
    public E createExchange(ExchangePattern pattern) {
        return (E)new DefaultExchange(this.getCamelContext(), pattern);
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    protected ScheduledThreadPoolExecutor createExecutorService() {
        return new ScheduledThreadPoolExecutor(10);
    }

    @Override
    public void configureProperties(Map options) {
    }

    protected String createEndpointUri() {
        return null;
    }

    protected void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    @Deprecated
    public CamelContext getContext() {
        return this.getCamelContext();
    }

    @Override
    @Deprecated
    public void setContext(CamelContext context) {
        this.setCamelContext(context);
    }
}

