/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelayProcessorSupport;

public class Throttler
extends DelayProcessorSupport {
    private long maximumRequestsPerPeriod;
    private long timePeriodMillis;
    private long startTimeMillis;
    private long requestCount;

    public Throttler(Processor processor, long maximumRequestsPerPeriod) {
        this(processor, maximumRequestsPerPeriod, 1000L);
    }

    public Throttler(Processor processor, long maximumRequestsPerPeriod, long timePeriodMillis) {
        super(processor);
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
        this.timePeriodMillis = timePeriodMillis;
    }

    public String toString() {
        return "Throttler[requests: " + this.maximumRequestsPerPeriod + " per: " + this.timePeriodMillis + " (ms) to: " + this.getProcessor() + "]";
    }

    public long getMaximumRequestsPerPeriod() {
        return this.maximumRequestsPerPeriod;
    }

    public void setMaximumRequestsPerPeriod(long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public long getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    protected void delay(Exchange exchange) throws Exception {
        long now = this.currentSystemTime();
        if (this.startTimeMillis == 0L) {
            this.startTimeMillis = now;
        }
        if (now - this.startTimeMillis > this.timePeriodMillis) {
            this.requestCount = 1L;
            this.startTimeMillis = now;
        } else if (++this.requestCount > this.maximumRequestsPerPeriod) {
            long time = this.startTimeMillis + this.timePeriodMillis;
            this.waitUntil(time, exchange);
        }
    }
}

