/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.processor.interceptor.ExchangeFormatter;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraceInterceptor
extends DelegateProcessor
implements ExchangeFormatter {
    private final ProcessorType node;
    private Predicate traceFilter;
    private boolean traceExceptions = true;
    private Logger logger = new Logger(LogFactory.getLog(TraceInterceptor.class), this);
    private TraceFormatter formatter;

    public TraceInterceptor(ProcessorType node, Processor target, TraceFormatter formatter) {
        super(target);
        this.node = node;
        this.formatter = formatter;
    }

    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void process(Exchange exchange) throws Exception {
        try {
            if (this.shouldLogExchange(exchange)) {
                this.logExchange(exchange);
            }
            super.proceed(exchange);
        }
        catch (Exception e) {
            this.logException(exchange, e);
            throw e;
        }
        catch (Error e) {
            this.logException(exchange, e);
            throw e;
        }
    }

    public Object format(Exchange exchange) {
        return this.formatter.format(this, exchange);
    }

    public ProcessorType getNode() {
        return this.node;
    }

    public Predicate getTraceFilter() {
        return this.traceFilter;
    }

    public void setTraceFilter(Predicate traceFilter) {
        this.traceFilter = traceFilter;
    }

    public boolean isTraceExceptions() {
        return this.traceExceptions;
    }

    public void setTraceExceptions(boolean traceExceptions) {
        this.traceExceptions = traceExceptions;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(TraceFormatter formatter) {
        this.formatter = formatter;
    }

    public LoggingLevel getLevel() {
        return this.getLogger().getLevel();
    }

    public Log getLog() {
        return this.getLogger().getLog();
    }

    public void setLog(Log log) {
        this.getLogger().setLog(log);
    }

    public void setLevel(LoggingLevel level) {
        this.getLogger().setLevel(level);
    }

    protected void logExchange(Exchange exchange) {
        this.logger.process(exchange);
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        this.logger.process(exchange, throwable);
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return this.traceFilter == null || this.traceFilter.matches(exchange);
    }
}

