/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceSender
extends Thread {
    private static final transient Log LOG = LogFactory.getLog(SequenceSender.class);
    private static final Exchange STOP = SequenceSender.createStopSignal();
    private BlockingQueue<Exchange> queue;
    private Processor processor;

    public SequenceSender(Processor processor) {
        this.processor = processor;
    }

    public void setQueue(BlockingQueue<Exchange> queue) {
        this.queue = queue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Exchange exchange;
                    if ((exchange = this.queue.take()) == STOP) {
                        LOG.info((Object)"Exit processing loop after cancellation");
                        return;
                    }
                    this.processor.process(exchange);
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Exit processing loop after interrupt");
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)("Exception during exchange processing: " + e.getMessage()));
                continue;
            }
            break;
        }
    }

    public void cancel() throws InterruptedException {
        this.queue.put(STOP);
    }

    private static Exchange createStopSignal() {
        return (Exchange)Proxy.newProxyInstance(SequenceSender.class.getClassLoader(), new Class[]{Exchange.class}, SequenceSender.createStopHandler());
    }

    private static InvocationHandler createStopHandler() {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new RuntimeException("Illegal method invocation on stop signal");
            }
        };
    }
}

