/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveElementFromXMLPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_ELEMENT_ID = "elementId";
    private String _elementId;

    public void configure(AnyMap configuration) throws ProcessingException {
        super.configure(configuration);
        this._elementId = configuration.getStringValue(PROP_ELEMENT_ID);
        if (this._elementId == null || this._elementId.trim().length() == 0) {
            throw new ProcessingException("Property elementId must not be <null> or an empty String");
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    String id = stringArray[n2];
                    try {
                        Document inputDocument = this.createDocument(blackboard, id);
                        if (inputDocument != null) {
                            Element el = inputDocument.getElementById(this._elementId);
                            if (el != null) {
                                Node parent = el.getParentNode();
                                parent.removeChild(el);
                            }
                            this.storeDocument(blackboard, id, inputDocument);
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block6;
                        this._log.warn((Object)("unable to transform document " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

