/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.cmd.CmdConsole;
import org.eclipse.smila.management.jmx.client.cmd.task.Task;
import org.eclipse.smila.management.jmx.client.cmd.task.impl.AttributeTask;
import org.eclipse.smila.management.jmx.client.cmd.task.impl.CustomTask;
import org.eclipse.smila.management.jmx.client.cmd.task.impl.OperationTask;
import org.eclipse.smila.management.jmx.client.cmd.task.impl.RegexpTask;
import org.eclipse.smila.management.jmx.client.cmd.task.impl.WaitTask;
import org.eclipse.smila.management.jmx.client.config.AttributeType;
import org.eclipse.smila.management.jmx.client.config.CmdConfigType;
import org.eclipse.smila.management.jmx.client.config.ConnectionConfigType;
import org.eclipse.smila.management.jmx.client.config.CustomType;
import org.eclipse.smila.management.jmx.client.config.ItemType;
import org.eclipse.smila.management.jmx.client.config.OperationType;
import org.eclipse.smila.management.jmx.client.config.RegexpType;
import org.eclipse.smila.management.jmx.client.config.WaitType;
import org.eclipse.smila.management.jmx.client.exceptions.JmxConnectionException;
import org.eclipse.smila.management.jmx.client.exceptions.OperationException;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;

public class CmdConsoleImpl
implements CmdConsole {
    protected Log _log = LogFactory.getLog(this.getClass());
    private final Map<Class, Task> _tasks = new HashMap<Class, Task>();

    public CmdConsoleImpl() {
        this._tasks.put(AttributeType.class, new AttributeTask());
        this._tasks.put(OperationType.class, new OperationTask());
        this._tasks.put(RegexpType.class, new RegexpTask());
        this._tasks.put(WaitType.class, new WaitTask());
        this._tasks.put(CustomType.class, new CustomTask());
    }

    @Override
    public Object execute(CmdConfigType cmdConfig, ConnectionConfigType connectionConfig, String[] parameters) throws JmxConnectionException, OperationException {
        JmxConnection connection = new JmxConnection(connectionConfig);
        connection.connect();
        return this.execute(cmdConfig, connection, null, parameters);
    }

    @Override
    public Object execute(CmdConfigType cmdConfig, JmxConnection connection, Object globalResult, String[] parameters) throws OperationException {
        Object localResult = null;
        for (ItemType item : cmdConfig.getAttributeOrOperationOrRegexp()) {
            Task task = this._tasks.get(item.getClass());
            if (task == null) {
                throw new RuntimeException(String.format("Processing of [%s] is not implemented!", item.getClass()));
            }
            localResult = task.execute(item, connection, globalResult, parameters, localResult);
        }
        return localResult;
    }
}

