/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.osgi;

import java.util.Hashtable;
import org.eclipse.persistence.internal.jpa.deployment.osgi.OSGiPersistenceInitializationHelper;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static BundleContext context;
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    public static final String ECLIPSELINK_OSGI_PROVIDER = "org.eclipse.persistence.jpa.osgi.PersistenceProviderOSGi";

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                this.registerBundle(event.getBundle());
                break;
            }
            case 256: {
                this.deregisterBundle(event.getBundle());
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        String initializer = null;
        ServiceReference packageAdminRef = context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(packageAdminRef);
        Bundle[] fragments = packageAdmin.getFragments(context.getBundle());
        if (fragments != null) {
            for (int i = 0; i < fragments.length; ++i) {
                Bundle fragment = fragments[i];
                initializer = (String)fragment.getHeaders().get("JPA-Initializer");
                if (initializer == null) continue;
                AbstractSessionLog.getLog().log(4, LoggingLocalization.buildMessage((String)"osgi_initializer", (Object[])new Object[]{initializer}));
                break;
            }
        }
        this.registerBundleListener();
        this.registerProviderService(initializer);
    }

    private void registerBundleListener() {
        Activator.getContext().addBundleListener((BundleListener)this);
        Bundle[] bundles = Activator.getContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            this.registerBundle(bundle);
        }
    }

    private void registerBundle(Bundle bundle) {
        if ((bundle.getState() & 0x28) != 0) {
            try {
                String[] persistenceUnitNames = this.getPersistenceUnitNames(bundle);
                if (persistenceUnitNames != null) {
                    OSGiPersistenceInitializationHelper.addBundle(bundle, persistenceUnitNames);
                }
            }
            catch (Exception e) {
                AbstractSessionLog.getLog().logThrowable(6, (Throwable)e);
            }
        }
    }

    private String[] getPersistenceUnitNames(Bundle bundle) {
        String names = (String)bundle.getHeaders().get("JPA-PersistenceUnits");
        if (names != null) {
            return names.split(",");
        }
        return null;
    }

    private void deregisterBundle(Bundle bundle) {
        OSGiPersistenceInitializationHelper.removeBundle(bundle);
    }

    public void stop(BundleContext context) throws Exception {
        Activator.getContext().removeBundleListener((BundleListener)this);
    }

    public static BundleContext getContext() {
        return context;
    }

    public void registerProviderService(String initializer) throws Exception {
        PersistenceProvider providerService = new PersistenceProvider(initializer);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(PERSISTENCE_PROVIDER, ECLIPSELINK_OSGI_PROVIDER);
        Activator.getContext().registerService(PERSISTENCE_PROVIDER, (Object)providerService, props);
    }
}

