/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.lucene.LuceneSearchService;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;
import org.eclipse.smila.utils.service.ServiceUtils;

public class LuceneSearchPipelet
implements Pipelet {
    private final Log _log = LogFactory.getLog(LuceneSearchPipelet.class);
    private LuceneSearchService _service;
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] message) throws ProcessingException {
        if (message.length > 0) {
            String requestId = message[0];
            QueryParameterAccessor parameters = new QueryParameterAccessor(blackboard, this._configuration, requestId);
            try {
                LuceneSearchService service = this.getLuceneSearchService();
                service.search(blackboard, requestId, parameters);
            }
            catch (Exception ex) {
                throw new ProcessingException("Error processing message " + requestId, (Throwable)ex);
            }
        }
        return message;
    }

    private synchronized LuceneSearchService getLuceneSearchService() throws InterruptedException {
        if (this._service == null) {
            this._service = (LuceneSearchService)ServiceUtils.getService(LuceneSearchService.class);
        }
        return this._service;
    }
}

