/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedCondition;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;
import org.eclipse.smila.search.lucene.index.access.IndexWriterPool;
import org.eclipse.smila.search.lucene.index.access.SynchronizedAbstractExecutor;

public class SynchronizedIndexWriterExecutor<ReturnedType>
extends SynchronizedAbstractExecutor<IndexWriter, ReturnedType> {
    private final String _indexName;
    private final String _storage;
    private final Analyzer _analyzer;
    private final IndexWriterCondition _condition;

    public SynchronizedIndexWriterExecutor(DIndex monitored, String storage, Analyzer analyzer) {
        super(monitored);
        this._indexName = monitored.getName();
        this._storage = storage;
        this._analyzer = analyzer;
        this._condition = new IndexWriterCondition();
    }

    @Override
    protected void close(IndexWriter object) throws IndexException {
        try {
            object.close();
        }
        catch (Throwable e) {
            throw new IndexException("Unable to close IndexWriter", e);
        }
    }

    @Override
    public ReturnedType execute(ISynchronizedOperation<IndexWriter, ReturnedType> operation) throws IndexException {
        return this.execute(this._condition, operation);
    }

    private class IndexWriterCondition
    implements ISynchronizedCondition<IndexWriter> {
        private IndexWriterCondition() {
        }

        @Override
        public IndexWriter initialize() throws IndexException {
            return IndexWriterPool.getIndexWriter(SynchronizedIndexWriterExecutor.this._indexName, SynchronizedIndexWriterExecutor.this._storage, SynchronizedIndexWriterExecutor.this._analyzer);
        }
    }
}

