/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import java.util.Iterator;
import org.eclipse.smila.search.lucene.messages.advsearch.DAnyFinderAdvSearch;
import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpression;
import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpressionCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DAnyFinderAdvSearchCodec {
    public static final String NS = "http://www.anyfinder.de/AdvancedSearch";

    private DAnyFinderAdvSearchCodec() {
    }

    public static Document encode(DAnyFinderAdvSearch dAnyFinderAdvSearch) throws AdvSearchException {
        Document doc = XMLUtils.getDocument();
        Element root = doc.createElementNS(NS, "AnyFinderAdvancedSearch");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://www.anyfinder.de/AdvancedSearch ../xml/AnyFinderAdvancedSearch.xsd");
        if (dAnyFinderAdvSearch.getVersion() != null) {
            root.setAttribute("Version", dAnyFinderAdvSearch.getVersion());
        }
        Iterator it = dAnyFinderAdvSearch.getQueryExpressions();
        while (it.hasNext()) {
            DQueryExpressionCodec.encode((DQueryExpression)it.next(), root);
        }
        doc.appendChild(root);
        return doc;
    }

    public static Element encode(DAnyFinderAdvSearch dAnyFinderAdvSearch, Element element) throws AdvSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS(NS, "AnyFinderAdvancedSearch");
        if (dAnyFinderAdvSearch.getVersion() != null) {
            el.setAttribute("Version", dAnyFinderAdvSearch.getVersion());
        }
        Iterator it = dAnyFinderAdvSearch.getQueryExpressions();
        while (it.hasNext()) {
            DQueryExpressionCodec.encode((DQueryExpression)it.next(), el);
        }
        element.appendChild(el);
        return el;
    }

    public static DAnyFinderAdvSearch decode(Element eAdvSearch) throws AdvSearchException {
        if (!"AnyFinderAdvancedSearch".equals(eAdvSearch.getLocalName())) {
            throw new AdvSearchException("Illegal element: Expected <AnyFinderAdvancedSearch>.");
        }
        DAnyFinderAdvSearch dAnyFinderAdvSearch = new DAnyFinderAdvSearch();
        String version = eAdvSearch.getAttribute("Version");
        if (version != null && !version.equals("")) {
            dAnyFinderAdvSearch.setVersion(version);
        }
        NodeList nl = eAdvSearch.getChildNodes();
        int i = 0;
        i = 0;
        while (i < nl.getLength()) {
            if ("QueryExpression".equals(nl.item(i).getLocalName())) {
                dAnyFinderAdvSearch.addQueryExpression(DQueryExpressionCodec.decode((Element)nl.item(i)));
            }
            ++i;
        }
        if (i < 1) {
            throw new AdvSearchException("Mandatory child QueryExpression missing in AnyFinderAdvancedSearch.");
        }
        return dAnyFinderAdvSearch;
    }
}

