/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DOPNCodec {
    private DOPNCodec() {
    }

    public static Element encode(DOPN dOPN, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "OP_N"));
        me.setAttribute("Operation", String.valueOf(dOPN.getOperation()));
        if (dOPN.getTermCount() < 2) {
            throw new AdvSearchException("Error: OP_N must have at least two terms");
        }
        int i = 0;
        while (i < dOPN.getTermCount()) {
            DTermCodec.encode(dOPN.getTerm(i), me);
            ++i;
        }
        return me;
    }

    public static DOPN decode(Element element) throws AdvSearchException {
        try {
            DOPN dOPN = new DOPN();
            dOPN.setOperation(element.getAttribute("Operation"));
            NodeList nl = element.getChildNodes();
            if (nl.getLength() < 2) {
                throw new AdvSearchException("Error: OP_N must have at least two terms");
            }
            int i = 0;
            while (i < nl.getLength()) {
                if (i >= nl.getLength()) break;
                if ("Term".equals(nl.item(i).getLocalName())) {
                    dOPN.addTerm(DTermCodec.decode((Element)nl.item(i)));
                }
                ++i;
            }
            return dOPN;
        }
        catch (Exception exception) {
            throw new AdvSearchException("Error in attributes to OP_N!");
        }
    }
}

