/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DDateTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DDateTemplateFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumberTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumberTemplateFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextTemplateFieldCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformer;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformerCodec;
import org.eclipse.smila.search.utils.search.parameterobjects.DTransformer;
import org.eclipse.smila.search.utils.search.parameterobjects.DTransformerCodec;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DTemplateFieldCodec {
    private DTemplateFieldCodec() {
    }

    public static Element encode(DTemplateField dTemplateField, Element parent) throws AdvSearchException {
        if (dTemplateField instanceof DTextTemplateField) {
            return DTextTemplateFieldCodec.encode((DTextTemplateField)dTemplateField, parent);
        }
        if (dTemplateField instanceof DNumberTemplateField) {
            return DNumberTemplateFieldCodec.encode((DNumberTemplateField)dTemplateField, parent);
        }
        return DDateTemplateFieldCodec.encode((DDateTemplateField)dTemplateField, parent);
    }

    public static void encodeStandardValues(DTemplateField dTemplateField, Element element) throws AdvSearchException {
        element.setAttribute("FieldNo", String.valueOf(dTemplateField.getFieldNo()));
        element.setAttribute("SourceFieldNo", String.valueOf(dTemplateField.getSourceFieldNo()));
        if (dTemplateField.getNodeTransformer() != null) {
            try {
                DNodeTransformerCodec.encode((DNodeTransformer)dTemplateField.getNodeTransformer(), (Element)element);
            }
            catch (DSearchException e) {
                throw new AdvSearchException("Unable to encode NodeTransformer for field " + dTemplateField.getFieldNo() + ": " + e.getMessage());
            }
        }
        if (dTemplateField.getTransformer() != null) {
            try {
                DTransformerCodec.encode((DTransformer)dTemplateField.getTransformer(), (Element)element);
            }
            catch (DSearchException e) {
                throw new AdvSearchException("Unable to encode Transformer for field " + dTemplateField.getFieldNo() + ": " + e.getMessage());
            }
        }
    }

    public static void decodeStandardValues(DTemplateField dTemplateField, Element element) throws AdvSearchException {
        dTemplateField.setFieldNo(Integer.parseInt(element.getAttribute("FieldNo")));
        dTemplateField.setSourceFieldNo(Integer.parseInt(element.getAttribute("SourceFieldNo")));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("NodeTransformer".equals(nl.item(i).getLocalName())) {
                try {
                    dTemplateField.setNodeTransformer(DNodeTransformerCodec.decode((Element)((Element)nl.item(i))));
                }
                catch (DSearchException e) {
                    throw new AdvSearchException("Unable to encode NodeTransformer for field " + dTemplateField.getFieldNo() + ": " + e.getMessage());
                }
            }
            if ("Transformer".equals(nl.item(i).getLocalName())) {
                try {
                    dTemplateField.setTransformer(DTransformerCodec.decode((Element)((Element)nl.item(i))));
                }
                catch (DSearchException e) {
                    throw new AdvSearchException("Unable to encode Transformer for field " + dTemplateField.getFieldNo() + ": " + e.getMessage());
                }
            }
            ++i;
        }
    }

    public static DTemplateField decode(Element element) throws AdvSearchException {
        String type = element.getAttribute("xsi:type");
        if (type.equals("TextTemplateField")) {
            return DTextTemplateFieldCodec.decode(element);
        }
        if (type.equals("NumberTemplateField")) {
            return DNumberTemplateFieldCodec.decode(element);
        }
        return DDateTemplateFieldCodec.decode(element);
    }
}

