/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DDateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DDateFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumField;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DOP1;
import org.eclipse.smila.search.lucene.messages.advsearch.DOP1Codec;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPNCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DTemplateFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermContent;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextField;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DWMEAN;
import org.eclipse.smila.search.lucene.messages.advsearch.DWMEANCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DTermCodec {
    private DTermCodec() {
    }

    public static Element encode(DTerm dTerm, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Term"));
        DTermContent term = (DTermContent)dTerm.getTerm();
        if (term instanceof DTextField) {
            DTextFieldCodec.encode(dTerm.getTextField(), me);
        } else if (term instanceof DNumField) {
            DNumFieldCodec.encode(dTerm.getNumField(), me);
        } else if (term instanceof DDateField) {
            DDateFieldCodec.encode(dTerm.getDateField(), me);
        } else if (term instanceof DOP1) {
            DOP1Codec.encode(dTerm.getOP1(), me);
        } else if (term instanceof DOPN) {
            DOPNCodec.encode(dTerm.getOpN(), me);
        } else if (term instanceof DWMEAN) {
            DWMEANCodec.encode(dTerm.getWMEAN(), me);
        } else if (term instanceof DTemplateField) {
            DTemplateFieldCodec.encode(dTerm.getTemplateField(), me);
        } else {
            throw new AdvSearchException("unsupported term type [" + term.getClass() + "]");
        }
        return me;
    }

    public static DTerm decode(Element eTerm) throws AdvSearchException {
        DTerm dTerm = new DTerm();
        NodeList nl = eTerm.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() != 3) {
                if ("Field".equals(nl.item(i).getLocalName())) {
                    Element elField = (Element)nl.item(i);
                    String type = elField.getAttribute("xsi:type");
                    if ((type = XMLUtils.getLocalPart((String)type)).equals("TextField")) {
                        dTerm.setTerm(DTextFieldCodec.decode(elField));
                    } else if (type.equals("NumField")) {
                        dTerm.setTerm(DNumFieldCodec.decode(elField));
                    } else if (type.equals("DateField")) {
                        dTerm.setTerm(DDateFieldCodec.decode(elField));
                    } else if (type.endsWith("TemplateField")) {
                        dTerm.setTerm(DTemplateFieldCodec.decode(elField));
                    }
                } else if ("OP_1".equals(nl.item(i).getLocalName())) {
                    dTerm.setTerm(DOP1Codec.decode((Element)nl.item(i)));
                } else if ("OP_N".equals(nl.item(i).getLocalName())) {
                    dTerm.setTerm(DOPNCodec.decode((Element)nl.item(i)));
                } else if ("WMEAN".equals(nl.item(i).getLocalName())) {
                    dTerm.setTerm(DWMEANCodec.decode((Element)nl.item(i)));
                }
            }
            ++i;
        }
        if (dTerm.getTerm() == null) {
            throw new AdvSearchException("Expected child in Term missing!");
        }
        return dTerm;
    }
}

