/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.filter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.IFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.WorkTypeFiltersCollection;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.CrawlScope;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;

public class CrawlScopeFilter
implements IFilter<Outlink> {
    private static final char SLASH = '/';
    private final Set<String> _seedHosts = new HashSet<String>();
    private final List<String> _seedPaths = new ArrayList<String>();
    private CrawlScope _crawlScope = CrawlScope.BROAD;
    private WorkTypeFiltersCollection _urlFilters = new WorkTypeFiltersCollection();

    public void setSeeds(Set<Outlink> seeds) {
        for (Outlink seed : seeds) {
            String host = seed.getUrl().getHost();
            this._seedHosts.add(host);
            String fullPath = seed.getUrl().getPath();
            String path = fullPath.lastIndexOf(47) != -1 ? String.valueOf(host) + fullPath.substring(0, fullPath.lastIndexOf(47)) : String.valueOf(host) + fullPath;
            this._seedPaths.add(path);
        }
    }

    @Override
    public boolean matches(Outlink link) {
        boolean linkMatches = false;
        String linkHost = link.getUrl().getHost();
        if (this._crawlScope.equals((Object)CrawlScope.BROAD)) {
            linkMatches = true;
        } else if (this._crawlScope.equals((Object)CrawlScope.HOST)) {
            linkMatches = this._seedHosts.contains(linkHost);
        } else if (this._crawlScope.equals((Object)CrawlScope.DOMAIN)) {
            String inversedHost = new StringBuffer(linkHost).reverse().toString();
            Iterator<String> seedHostsIterator = this._seedHosts.iterator();
            while (seedHostsIterator.hasNext() && !linkMatches) {
                String testHost = seedHostsIterator.next();
                String inversedTestHost = new StringBuffer(testHost).reverse().toString();
                linkMatches = inversedHost.startsWith(inversedTestHost);
            }
        } else if (this._crawlScope.equals((Object)CrawlScope.PATH)) {
            String linkPath = String.valueOf(linkHost) + link.getUrl().getPath();
            for (String path : this._seedPaths) {
                if (!linkPath.startsWith(path)) continue;
                linkMatches = true;
                break;
            }
        }
        linkMatches = linkMatches ? !this.matchesFilter(this.getUrlFilters().getUnselectFilters(), link) : this.matchesFilter(this.getUrlFilters().getSelectFilters(), link);
        return linkMatches;
    }

    public CrawlScope getCrawlScope() {
        return this._crawlScope;
    }

    public void setCrawlScope(CrawlScope scope) {
        this._crawlScope = scope;
    }

    public WorkTypeFiltersCollection getUrlFilters() {
        return this._urlFilters;
    }

    public void setUrlFilters(WorkTypeFiltersCollection filters) {
        this._urlFilters = filters;
    }

    private boolean matchesFilter(List<IFilter> filters, Outlink link) {
        boolean matches = false;
        for (IFilter filter : filters) {
            if (!filter.matches(link)) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

