/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing.impl;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.smila.connectivity.ConnectivityId;

public class IdIterator
implements Iterator<ConnectivityId> {
    private final Iterator<ConnectivityId> _oldIndexIterator;
    private final Set<ConnectivityId> _newIndex;
    private final Set<ConnectivityId> _modifiedCompounds;
    private ConnectivityId _next;

    public IdIterator(Set<ConnectivityId> oldIndex, Set<ConnectivityId> newIndex, Set<ConnectivityId> modifiedCompounds) {
        this._oldIndexIterator = oldIndex.iterator();
        this._newIndex = newIndex;
        this._modifiedCompounds = modifiedCompounds;
    }

    @Override
    public boolean hasNext() {
        if (this._next != null) {
            return true;
        }
        this.tryMoveNext();
        return this._next != null;
    }

    @Override
    public ConnectivityId next() {
        if (this._next != null) {
            return this.shift();
        }
        this.tryMoveNext();
        return this.shift();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("use delete(Id) method of delta indexing manager instead");
    }

    private void tryMoveNext() {
        this._next = null;
        while (this._oldIndexIterator.hasNext()) {
            ConnectivityId id = this._oldIndexIterator.next();
            if (this._newIndex.contains(id) || !this.isNotCompoundOrCompoundIsModified(id)) continue;
            this._next = id;
            return;
        }
    }

    private ConnectivityId shift() {
        ConnectivityId next = this._next;
        this._next = null;
        return next;
    }

    private boolean isNotCompoundOrCompoundIsModified(ConnectivityId id) {
        ConnectivityId parentId = null;
        parentId = id.getContainerId();
        if (parentId == null) {
            return true;
        }
        boolean parentVisited = this._newIndex.contains(parentId);
        boolean modifiedCompound = this._modifiedCompounds.contains(parentId);
        return !parentVisited || modifiedCompound;
    }
}

