/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.util;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smila.http.server.util.RequestHandler;
import org.osgi.service.component.ComponentContext;

public abstract class ARequestHandler
implements RequestHandler {
    private String _rootContextPath;
    private String _uriPattern;

    @Override
    public final String getRootContextPath() {
        return this._rootContextPath;
    }

    @Override
    public final String getUriPattern() {
        return this._uriPattern;
    }

    @Override
    public final boolean matches(String requestUri) {
        String uriPart = requestUri.substring(this._rootContextPath.length());
        return uriPart.matches(this._uriPattern);
    }

    public final List<String> getDynamicUriParts(String requestUri) {
        ArrayList<String> groups = new ArrayList<String>();
        String uriPart = requestUri.substring(this._rootContextPath.length());
        Pattern pattern = Pattern.compile(this._uriPattern);
        Matcher matcher = pattern.matcher(uriPart);
        matcher.find();
        if (matcher.groupCount() >= 1) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                groups.add(this.urlDecode(matcher.group(i)));
                ++i;
            }
        }
        return groups;
    }

    public final String getStaticUriParts(String requestUri) {
        String uriPart = requestUri.substring(this._rootContextPath.length());
        Pattern pattern = Pattern.compile(this._uriPattern);
        Matcher matcher = pattern.matcher(uriPart);
        matcher.find();
        if (matcher.groupCount() > 0 && matcher.start(1) >= 0) {
            return this.urlDecode(uriPart.substring(0, matcher.start(1)));
        }
        return this.urlDecode(requestUri);
    }

    protected void activate(ComponentContext context) {
        this._rootContextPath = context.getProperties().get("rootContextPath").toString();
        this._uriPattern = context.getProperties().get("uriPattern").toString();
    }

    protected String urlDecode(String urlPart) {
        if (urlPart == null) {
            return null;
        }
        try {
            return URLDecoder.decode(urlPart, "utf-8");
        }
        catch (Exception exception) {
            return URLDecoder.decode(urlPart);
        }
    }
}

