/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractLoggedComponent;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.task.TaskListExecutionService;
import org.eclipse.smila.connectivity.queue.worker.jms.BrokerConnectionService;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.recordstorage.RecordStorage;

public abstract class AbstractQueueServicesAccessPoint
extends AbstractLoggedComponent
implements ServicesAccessPoint {
    protected BrokerConnectionService _brokerConnections;
    private WorkflowProcessor _workflowProcessor;
    private BlackboardFactory _blackboardFactory;
    private RecordStorage _recordStorage;
    private TaskListExecutionService _taskListExecutionService;
    private ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    public AbstractQueueServicesAccessPoint(String id) {
        super(id);
    }

    public void setBrokerConnections(BrokerConnectionService brokerConnections) {
        this._brokerConnections = brokerConnections;
    }

    public void unsetBrokerConnections(BrokerConnectionService brokerConnections) {
        if (brokerConnections == this._brokerConnections) {
            this.getManagementLock().lock();
            this._brokerConnections = null;
            this.getManagementLock().unlock();
        }
    }

    public void setBlackboardFactory(BlackboardFactory blackboardFactory) {
        this._blackboardFactory = blackboardFactory;
    }

    public void unsetBlackboardFactory(BlackboardFactory blackboardFactory) {
        if (this._blackboardFactory == blackboardFactory) {
            this.getManagementLock().lock();
            this._blackboardFactory = null;
            this.getManagementLock().unlock();
        }
    }

    public void setRecordStorage(RecordStorage recordStorage) {
        this._recordStorage = recordStorage;
    }

    public void unsetRecordStorage(RecordStorage recordStorage) {
        if (recordStorage == this._recordStorage) {
            this.getManagementLock().lock();
            this._recordStorage = null;
            this.getManagementLock().unlock();
        }
    }

    public void setWorkflowProcessor(WorkflowProcessor workflowProcessor) {
        this._workflowProcessor = workflowProcessor;
    }

    public void unsetWorkflowProcessor(WorkflowProcessor workflowProcessor) {
        if (workflowProcessor == this._workflowProcessor) {
            this.getManagementLock().lock();
            this._workflowProcessor = null;
            this.getManagementLock().unlock();
        }
    }

    @Override
    public BrokerConnectionService getBrokerConnections() {
        if (this._brokerConnections == null) {
            throw new RuntimeException("BrokerConnectionService is not set!");
        }
        return this._brokerConnections;
    }

    @Override
    public Blackboard getBlackboardService(boolean persisting) throws BlackboardAccessException {
        if (this._blackboardFactory == null) {
            throw new RuntimeException("BlackboardService is not set!");
        }
        if (persisting) {
            return this._blackboardFactory.createPersistingBlackboard();
        }
        return this._blackboardFactory.createTransientBlackboard();
    }

    @Override
    public RecordStorage getRecordStorage() {
        if (this._recordStorage == null) {
            throw new RuntimeException("RecordStorage is not set!");
        }
        return this._recordStorage;
    }

    @Override
    public WorkflowProcessor getWorkflowProcessor() {
        if (this._workflowProcessor == null) {
            throw new RuntimeException("WorkflowProcessor is not set!");
        }
        return this._workflowProcessor;
    }

    @Override
    public TaskListExecutionService getTaskListExecutionService() {
        if (this._taskListExecutionService == null) {
            throw new RuntimeException("TaskListExecutionService is not set!");
        }
        return this._taskListExecutionService;
    }

    @Override
    public Lock getProcessingLock() {
        return this._lock.readLock();
    }

    protected Lock getManagementLock() {
        return this._lock.writeLock();
    }

    public void start() {
        this._taskListExecutionService = new TaskListExecutionService();
    }

    public void stop() {
        this._taskListExecutionService = null;
    }
}

