/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.recycler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.connectivity.queue.worker.RecordRecycler;
import org.eclipse.smila.connectivity.queue.worker.RecordRecyclerException;
import org.eclipse.smila.connectivity.queue.worker.RecordRecyclerStatus;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractQueueServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.recycler.Recycler;
import org.eclipse.smila.connectivity.queue.worker.internal.recycler.RecyclerImpl;
import org.eclipse.smila.utils.config.ConfigUtils;

public class RecordRecyclerImpl
extends AbstractQueueServicesAccessPoint
implements RecordRecycler {
    private final Object _monitor = new Object();
    private final Map<String, Thread> _threads = new HashMap<String, Thread>();
    private final Map<String, Recycler> _recyclers = new HashMap<String, Recycler>();

    public RecordRecyclerImpl() {
        super("RecordRecycler");
    }

    public void recycle(String configurationId, String dataSourceId) throws RecordRecyclerException {
        Recycler recycler = this.initRecycler(configurationId, dataSourceId);
        recycler.recycle();
        recycler.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleAsync(String configurationId, String dataSourceId) throws RecordRecyclerException {
        Object object = this._monitor;
        synchronized (object) {
            Recycler recycler = this.initRecycler(configurationId, dataSourceId);
            Thread thread = new Thread(recycler);
            this._threads.put(dataSourceId, thread);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecycle(String dataSourceId) throws RecordRecyclerException {
        Object object = this._monitor;
        synchronized (object) {
            Recycler recycler = this._recyclers.get(dataSourceId);
            if (recycler == null) {
                throw new RecordRecyclerException(String.format("Recycler for data source [%s] is not found", dataSourceId));
            }
            recycler.stopRecycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecordsRecycled(String dataSourceId) {
        Object object = this._monitor;
        synchronized (object) {
            Recycler recycler;
            block4: {
                recycler = this._recyclers.get(dataSourceId);
                if (recycler != null) break block4;
                return 0L;
            }
            return recycler.getRecordsRecycled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordRecyclerStatus getStatus(String dataSourceId) {
        Object object = this._monitor;
        synchronized (object) {
            Recycler recycler = this._recyclers.get(dataSourceId);
            if (recycler == null) {
                return RecordRecyclerStatus.FINISHED;
            }
            return recycler.getStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Recycler initRecycler(String configurationId, String dataSourceId) throws RecordRecyclerException {
        Object object = this._monitor;
        synchronized (object) {
            Recycler recycler;
            Thread thread = this._threads.get(dataSourceId);
            if (thread != null) {
                if (thread.isAlive()) {
                    throw new RecordRecyclerException(String.format("DataSource %s is busy", dataSourceId));
                }
                this._threads.remove(dataSourceId);
            }
            if ((recycler = this._recyclers.get(dataSourceId)) != null) {
                if (recycler.getStatus() != RecordRecyclerStatus.FINISHED) {
                    throw new RecordRecyclerException(String.format("DataSource %s is busy", dataSourceId));
                }
                this._recyclers.remove(dataSourceId);
                recycler.stop();
            }
            recycler = new RecyclerImpl(configurationId, this, dataSourceId);
            recycler.start();
            this._recyclers.put(dataSourceId, recycler);
            return recycler;
        }
    }

    public String[] getConfigurations() throws RecordRecyclerException {
        List entries = ConfigUtils.getConfigEntries((String)"org.eclipse.smila.connectivity.queue.worker.jms", (String)"recyclers");
        ArrayList<String> configs = new ArrayList<String>();
        for (String entry : entries) {
            if (!entry.toLowerCase().endsWith(".xml")) continue;
            configs.add(entry.substring(0, entry.length() - 4));
        }
        return configs.toArray(new String[configs.size()]);
    }
}

