/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.internal;

import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.api.internal.ResultDocumentBuilder;
import org.eclipse.smila.utils.xml.XmlHelper;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;

public class SearchServiceImpl
implements SearchService {
    private static final long NANO_TO_MILLIS = 1000000L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private WorkflowProcessor _processor;
    private BlackboardFactory _blackboardFactory;
    private final ResultDocumentBuilder _resultBuilder = new ResultDocumentBuilder();

    public SearchServiceImpl() {
        this._log.debug((Object)"instance created.");
    }

    @Override
    public Record search(String workflowName, Record query) throws ProcessingException {
        try {
            long starttime = System.nanoTime();
            this.ensureQueryId(workflowName, query);
            Blackboard blackboard = this._blackboardFactory.createTransientBlackboard();
            blackboard.setRecord(query);
            String[] resultIds = this._processor.process(workflowName, blackboard, new String[]{query.getId()});
            Record result = null;
            if (resultIds != null && resultIds.length > 0) {
                long endtime = System.nanoTime();
                this.setRuntime(blackboard, resultIds[0], endtime - starttime);
                result = blackboard.getRecord(resultIds[0]);
            }
            blackboard.invalidate();
            return result;
        }
        catch (BlackboardAccessException ex) {
            throw new ProcessingException("Blackboard error: ", (Throwable)ex);
        }
    }

    @Override
    public Document searchAsXml(String workflowName, Record query) throws ParserConfigurationException {
        Document resultDoc = null;
        try {
            Record result = this.search(workflowName, query);
            resultDoc = this._resultBuilder.buildResult(workflowName, result);
        }
        catch (ProcessingException ex) {
            resultDoc = this._resultBuilder.buildError((Exception)((Object)ex));
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"XML result:");
            this._log.debug((Object)XmlHelper.toString((Document)resultDoc));
        }
        return resultDoc;
    }

    @Override
    public String searchAsXmlString(String workflowName, Record query) throws ParserConfigurationException {
        Document result = this.searchAsXml(workflowName, query);
        return XmlHelper.toString((Document)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQueryId(String workflowName, Record query) {
        if (query.getId() == null) {
            UUID uuid = null;
            SearchServiceImpl searchServiceImpl = this;
            synchronized (searchServiceImpl) {
                uuid = UUID.randomUUID();
            }
            query.setId(String.valueOf(workflowName) + "-" + uuid.toString());
        }
    }

    protected void activate(ComponentContext context) {
        this._log.debug((Object)"activating");
        this._log.info((Object)"active!");
    }

    protected void deactivate(ComponentContext context) {
        this._log.debug((Object)"deactivating");
        this._log.info((Object)"inactive!");
    }

    public void setProcessor(WorkflowProcessor processor) {
        this._log.debug((Object)"setting processor reference.");
        this._processor = processor;
    }

    public void unsetProcessor(WorkflowProcessor processor) {
        if (this._processor == processor) {
            this._log.debug((Object)"unsetting processor reference.");
            this._processor = null;
        }
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._log.debug((Object)"setting blackboard factory.");
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._log.debug((Object)"unsetting blackboard factory.");
            this._blackboardFactory = null;
        }
    }

    private void setRuntime(Blackboard blackboard, String record, long runtime) throws BlackboardAccessException {
        long msRuntime = runtime / 1000000L;
        blackboard.getMetadata(record).put((Object)"runtime", (Object)blackboard.getDataFactory().createLongValue(Long.valueOf(msRuntime)));
    }
}

