/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.impl.AnyMapImpl;
import org.eclipse.smila.datamodel.impl.DefaultDataFactoryImpl;
import org.eclipse.smila.datamodel.impl.ValueImpl;

public class RecordImpl
implements Record,
Serializable {
    private static final long serialVersionUID = 1L;
    private final AnyMap _metadata = new AnyMapImpl();
    private final Map<String, byte[]> _attachments = new LinkedHashMap<String, byte[]>();

    @Override
    public String getId() {
        return this._metadata.getStringValue("_recordid");
    }

    @Override
    public String getSource() {
        return this._metadata.getStringValue("_source");
    }

    @Override
    public AnyMap getMetadata() {
        return this._metadata;
    }

    @Override
    public int attachmentSize() {
        return this._attachments.size();
    }

    @Override
    public byte[] getAttachment(String name) {
        return this._attachments.get(name);
    }

    @Override
    public Iterator<String> getAttachmentNames() {
        return this._attachments.keySet().iterator();
    }

    @Override
    public boolean hasAttachments() {
        return !this._attachments.isEmpty();
    }

    @Override
    public boolean hasAttachment(String name) {
        return this._attachments.containsKey(name);
    }

    @Override
    public void removeAttachment(String name) {
        this._attachments.remove(name);
    }

    @Override
    public void removeAttachments() {
        this._attachments.clear();
    }

    @Override
    public void setAttachment(String name, byte[] attachment) {
        this._attachments.put(name, attachment);
    }

    @Override
    public void setId(String id) {
        if (id != null) {
            this._metadata.put("_recordid", new ValueImpl(Any.ValueType.STRING, id));
        }
    }

    @Override
    public void setSource(String source) {
        if (source != null) {
            this._metadata.put("_source", new ValueImpl(Any.ValueType.STRING, source));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._metadata);
        if (this.hasAttachments()) {
            builder.append(" + ").append(this._attachments.keySet());
        }
        return builder.toString();
    }

    @Override
    public DataFactory getFactory() {
        return DefaultDataFactoryImpl.INSTANCE;
    }
}

