/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionContextImpl
implements ExtensionContext {
    private static final Log __log = LogFactory.getLog(ExtensionContextImpl.class);
    private OdeInternalInstance _context;
    private ScopeFrame _scopeFrame;
    private ActivityInfo _activityInfo;
    private boolean hasCompleted = false;

    public ExtensionContextImpl(ActivityInfo activityInfo, ScopeFrame scopeFrame, OdeInternalInstance odeInternalInstance) {
        this._activityInfo = activityInfo;
        this._context = odeInternalInstance;
        this._scopeFrame = scopeFrame;
    }

    @Override
    public Long getProcessId() {
        return this._context.getPid();
    }

    @Override
    public Map<String, OScope.Variable> getVisibleVariables() throws FaultException {
        HashMap<String, OScope.Variable> hashMap = new HashMap<String, OScope.Variable>();
        for (OActivity oActivity = this._scopeFrame.oscope; oActivity != null; oActivity = oActivity.getParent()) {
            if (!(oActivity instanceof OScope)) continue;
            for (String string : oActivity.variables.keySet()) {
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, oActivity.variables.get(string));
            }
        }
        return hashMap;
    }

    @Override
    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty oProperty) throws FaultException {
        VariableInstance variableInstance = this._scopeFrame.resolve(variable);
        return this._context.readProperty(variableInstance, oProperty);
    }

    @Override
    public Node readVariable(OScope.Variable variable) throws FaultException {
        VariableInstance variableInstance = this._scopeFrame.resolve(variable);
        return this._context.fetchVariableData(variableInstance, this._scopeFrame, true);
    }

    @Override
    public void writeVariable(String string, Node node) throws FaultException, ExternalVariableModuleException {
        OScope.Variable variable = this.getVisibleVariable(string);
        if (variable == null) {
            throw new RuntimeException("Variable '" + string + "' not visible.");
        }
        this.writeVariable(variable, node);
    }

    @Override
    public Node readVariable(String string) throws FaultException {
        OScope.Variable variable = this.getVisibleVariable(string);
        if (variable == null) {
            throw new RuntimeException("Variable '" + string + "' not visible.");
        }
        return this.readVariable(variable);
    }

    @Override
    public void writeVariable(OScope.Variable variable, Node node) throws FaultException, ExternalVariableModuleException {
        VariableInstance variableInstance = this._scopeFrame.resolve(variable);
        this._context.initializeVariable(variableInstance, this._scopeFrame, node);
        VariableModificationEvent variableModificationEvent = new VariableModificationEvent(variable.name);
        variableModificationEvent.setNewValue(node);
        this.sendEvent((ScopeEvent)variableModificationEvent);
    }

    public OScope.Variable getVisibleVariable(String string) {
        return this._scopeFrame.oscope.getVisibleVariable(string);
    }

    @Override
    public boolean isVariableVisible(String string) {
        return this._scopeFrame.oscope.getVisibleVariable(string) != null;
    }

    @Override
    public String getActivityName() {
        return this._activityInfo.o.name;
    }

    @Override
    public OActivity getOActivity() {
        return this._activityInfo.o;
    }

    public void sendEvent(ScopeEvent scopeEvent) {
        if (scopeEvent.getLineNo() == -1 && this._activityInfo.o.debugInfo != null) {
            scopeEvent.setLineNo(this._activityInfo.o.debugInfo.startLine);
        }
        this._scopeFrame.fillEventInfo(scopeEvent);
        this._context.sendEvent(scopeEvent);
    }

    @Override
    public void complete() {
        if (!this.hasCompleted) {
            this._activityInfo.parent.completed(null, CompensationHandler.emptySet());
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public void completeWithFault(Throwable throwable) {
        if (!this.hasCompleted) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            FaultData faultData = new FaultData(new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "subLanguageExecutionFault"), this._activityInfo.o, stringWriter.getBuffer().toString());
            this._activityInfo.parent.completed(faultData, CompensationHandler.emptySet());
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public void completeWithFault(FaultException faultException) {
        if (!this.hasCompleted) {
            FaultData faultData = new FaultData(faultException.getQName(), this._activityInfo.o, faultException.getMessage());
            this._activityInfo.parent.completed(faultData, CompensationHandler.emptySet());
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public OdeInternalInstance getInternalInstance() {
        return this._context;
    }

    @Override
    public URI getDUDir() {
        return this._context.getBaseResourceURI();
    }

    @Override
    public void printToConsole(String string) {
        LogFactory.getLog((String)"org.apache.ode.extension.Console").info((Object)string);
    }
}

