/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.pipelets.SourceType;

public abstract class ATransformationPipelet
implements Pipelet {
    public static final String PROP_INPUT_TYPE = "inputType";
    public static final String PROP_OUTPUT_TYPE = "outputType";
    public static final String PROP_INPUT_NAME = "inputName";
    public static final String PROP_OUTPUT_NAME = "outputName";
    public static final String ENCODING_ATTACHMENT = "utf-8";
    protected final Log _log = LogFactory.getLog(ATransformationPipelet.class);
    protected SourceType _inputType;
    protected SourceType _outputType;
    protected String _inputName;
    protected String _outputName;
    protected DataFactory _dataFactory = DataFactoryCreator.createDefaultFactory();

    public void configure(AnyMap configuration) throws ProcessingException {
        this._inputType = SourceType.valueOf(configuration.getStringValue(PROP_INPUT_TYPE));
        this._outputType = SourceType.valueOf(configuration.getStringValue(PROP_OUTPUT_TYPE));
        this._inputName = configuration.getStringValue(PROP_INPUT_NAME);
        this._outputName = configuration.getStringValue(PROP_OUTPUT_NAME);
    }

    public SourceType getInputType() {
        return this._inputType;
    }

    public String getInputName() {
        return this._inputName;
    }

    public SourceType getOutputType() {
        return this._outputType;
    }

    public String getOutputName() {
        return this._outputName;
    }

    public boolean isReadFromAttribute() {
        return SourceType.ATTRIBUTE.equals((Object)this._inputType);
    }

    public boolean isStoreInAttribute() {
        return SourceType.ATTRIBUTE.equals((Object)this._outputType);
    }

    protected void storeResult(Blackboard blackboard, String id, String result) throws ProcessingException {
        if (this.isStoreInAttribute()) {
            try {
                blackboard.getMetadata(id).put(this._outputName, result);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not set attribute " + this._outputName + " of record " + id, (Throwable)e);
            }
        }
        try {
            InputStream stringStream = IOUtils.toInputStream((String)result, (String)ENCODING_ATTACHMENT);
            blackboard.setAttachmentFromStream(id, this._outputName, stringStream);
        }
        catch (Exception e) {
            throw new ProcessingException("Could not set attachment " + this._outputName + " of record " + id, (Throwable)e);
        }
    }

    protected void storeResults(Blackboard blackboard, String id, Collection<String> results) throws ProcessingException, BlackboardAccessException {
        if (!results.isEmpty()) {
            if (this.isStoreInAttribute()) {
                AnySeq valueSeq = this._dataFactory.createAnySeq();
                for (String result : results) {
                    valueSeq.add(result);
                }
                blackboard.getMetadata(id).put((Object)this._outputName, (Object)valueSeq);
            } else {
                this.storeResult(blackboard, id, results.iterator().next());
            }
        }
    }

    protected void storeResult(Blackboard blackboard, String id, byte[] bytes) throws Exception {
        if (this.isStoreInAttribute()) {
            blackboard.getMetadata(id).put(this._outputName, new String(bytes, ENCODING_ATTACHMENT));
        } else {
            blackboard.setAttachment(id, this._outputName, bytes);
        }
    }

    protected byte[] readInput(Blackboard blackboard, String id) throws BlackboardAccessException, UnsupportedEncodingException {
        byte[] bytes = null;
        if (this.isReadFromAttribute()) {
            String value;
            Any inputAny = (Any)blackboard.getMetadata(id).get((Object)this._inputName);
            if (inputAny != null && inputAny.isValue() && (value = ((Value)inputAny).asString()) != null) {
                bytes = value.getBytes(ENCODING_ATTACHMENT);
            }
        } else if (blackboard.hasAttachment(id, this._inputName)) {
            bytes = blackboard.getAttachment(id, this._inputName);
        }
        return bytes;
    }

    protected String readStringInput(Blackboard blackboard, String id) throws BlackboardAccessException, UnsupportedEncodingException {
        byte[] bytes;
        String string = null;
        if (this.isReadFromAttribute()) {
            Any inputAny = (Any)blackboard.getMetadata(id).get((Object)this._inputName);
            if (inputAny != null && inputAny.isValue()) {
                string = ((Value)inputAny).asString();
            }
        } else if (blackboard.hasAttachment(id, this._inputName) && (bytes = blackboard.getAttachment(id, this._inputName)) != null && bytes.length > 0) {
            string = new String(bytes, ENCODING_ATTACHMENT);
        }
        return string;
    }
}

