/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.utils.service.ServiceUtils;

public class MimeTypeIdentifyPipelet
implements Pipelet {
    public static final String FILE_EXTENSION_ATTRIBUTE = "FileExtensionAttribute";
    public static final String CONTENT_ATTACHMENT = "ContentAttachment";
    public static final String META_DATA_ATTRIBUTE = "MetaDataAttribute";
    public static final String MIME_TYPE_ATTRIBUTE = "MimeTypeAttribute";
    private final Log _log = LogFactory.getLog(this.getClass());
    private String _extensionAttributeName;
    private String _contentAttachmentName;
    private String _metaDataAttributeName;
    private String _mimeTypeAttributeName;
    private AnyMap _configuration;
    private MimeTypeIdentifier _mimeTypeIdentifier;
    private final Pattern _contentTypePattern = Pattern.compile("^CONTENT-TYPE\\s*:\\s*([^\\s;=]+)(?:.|\\s)*$", 2);

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
        this._extensionAttributeName = this._configuration.getStringValue(FILE_EXTENSION_ATTRIBUTE);
        this._contentAttachmentName = this._configuration.getStringValue(CONTENT_ATTACHMENT);
        this._metaDataAttributeName = this._configuration.getStringValue(META_DATA_ATTRIBUTE);
        this._mimeTypeAttributeName = this._configuration.getStringValue(MIME_TYPE_ATTRIBUTE);
        if (this._extensionAttributeName == null && this._contentAttachmentName == null && this._metaDataAttributeName == null) {
            throw new ProcessingException("One of the config properties FileExtensionAttribute, ContentAttachment or MetaDataAttribute have to be specified!");
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        MimeTypeIdentifier identifier = this.getMimeTypeIdentifier();
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                String id = stringArray[n2];
                try {
                    this.identifyAndStore(blackboard, id, identifier);
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block3;
                    this._log.error((Object)("error identifying MimeType for record " + id), (Throwable)ex);
                }
            }
            ++n2;
        }
        return recordIds;
    }

    private synchronized MimeTypeIdentifier getMimeTypeIdentifier() throws ProcessingException {
        if (this._mimeTypeIdentifier == null) {
            try {
                this._mimeTypeIdentifier = (MimeTypeIdentifier)ServiceUtils.getService(MimeTypeIdentifier.class);
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error while waiting for MimeTypeIdentifier service to come up.", (Throwable)ex);
            }
            if (this._mimeTypeIdentifier == null) {
                throw new ProcessingException("No MimeTypeIdentifier service available, giving up");
            }
        }
        return this._mimeTypeIdentifier;
    }

    private void identifyAndStore(Blackboard blackboard, String id, MimeTypeIdentifier identifier) throws BlackboardAccessException, MimeTypeParseException {
        String extension;
        String mimeType = null;
        AnyMap metaData = blackboard.getMetadata(id);
        if (this._extensionAttributeName != null && this._contentAttachmentName != null) {
            extension = null;
            byte[] content = null;
            if (metaData.containsKey((Object)this._extensionAttributeName)) {
                extension = metaData.getStringValue(this._extensionAttributeName);
            }
            if (blackboard.hasAttachment(id, this._contentAttachmentName)) {
                content = blackboard.getAttachment(id, this._contentAttachmentName);
            }
            mimeType = identifier.identify(content, extension);
        } else if (this._extensionAttributeName != null) {
            if (metaData.containsKey((Object)this._extensionAttributeName) && (extension = metaData.getStringValue(this._extensionAttributeName)) != null) {
                mimeType = identifier.identify(extension);
            }
        } else if (this._contentAttachmentName != null && blackboard.hasAttachment(id, this._contentAttachmentName)) {
            byte[] content = blackboard.getAttachment(id, this._contentAttachmentName);
            mimeType = identifier.identify(content);
        }
        if (mimeType == null && this._metaDataAttributeName != null && metaData.containsKey((Object)this._metaDataAttributeName)) {
            AnySeq metaDataSeq = metaData.getSeq(this._metaDataAttributeName);
            for (Any any : metaDataSeq) {
                Matcher matcher;
                String metaDataValue;
                if (!any.isString() || (metaDataValue = ((Value)any).asString()) == null || !(matcher = this._contentTypePattern.matcher(metaDataValue)).find()) continue;
                mimeType = matcher.group(1);
                break;
            }
        }
        if (mimeType != null) {
            metaData.put(this._mimeTypeAttributeName, mimeType);
        } else if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("Unable to identify MimeType for Id " + id + ". No values found for " + FILE_EXTENSION_ATTRIBUTE));
        }
    }
}

