/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary.messages.ddconfig;

import org.eclipse.smila.search.datadictionary.messages.ddconfig.ConfigurationException;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConstraints;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DFieldConstraintsCodec {
    public static DFieldConstraints decode(Element element) throws ConfigurationException {
        DFieldConstraints dFieldConstraints = new DFieldConstraints();
        dFieldConstraints.setFieldNo(Integer.parseInt(element.getAttribute("FieldNo")));
        if (element.hasAttribute("Occurrence")) {
            dFieldConstraints.setOccurrence(element.getAttribute("Occurrence"));
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            Node textElement = node.getFirstChild();
            String text = null;
            if (textElement != null) {
                text = textElement.getNodeValue();
            }
            if ("FieldTemplate".equals(node.getLocalName())) {
                dFieldConstraints.addFieldTemplate(text);
            } else if ("NodeTransformer".equals(node.getLocalName())) {
                dFieldConstraints.addNodeTransformer(text);
            } else if ("Constraint".equals(node.getLocalName())) {
                dFieldConstraints.addConstraint(text);
            }
            ++i;
        }
        return dFieldConstraints;
    }

    public static Element encode(DFieldConstraints dFieldConstraints, Element element) throws ConfigurationException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/DataDictionary/Configuration", "FieldConstraints");
        el.setAttribute("FieldNo", "" + dFieldConstraints.getFieldNo());
        if (dFieldConstraints.getOccurrence() != null) {
            el.setAttribute("Occurrence", dFieldConstraints.getOccurrence());
        }
        String[] fieldTemplates = dFieldConstraints.getFieldTemplates();
        int i = 0;
        while (i < fieldTemplates.length) {
            Element e = doc.createElementNS("http://www.anyfinder.de/DataDictionary/Configuration", "FieldTemplate");
            e.appendChild(doc.createTextNode(fieldTemplates[i]));
            el.appendChild(e);
            ++i;
        }
        String[] nodeTransformers = dFieldConstraints.getNodeTransformers();
        int i2 = 0;
        while (i2 < nodeTransformers.length) {
            Element e = doc.createElementNS("http://www.anyfinder.de/DataDictionary/Configuration", "NodeTransformer");
            e.appendChild(doc.createTextNode(nodeTransformers[i2]));
            el.appendChild(e);
            ++i2;
        }
        String[] constraints = dFieldConstraints.getConstraints();
        int i3 = 0;
        while (i3 < constraints.length) {
            Element e = doc.createElementNS("http://www.anyfinder.de/DataDictionary/Configuration", "Constraint");
            e.appendChild(doc.createTextNode(constraints[i3]));
            el.appendChild(e);
            ++i3;
        }
        element.appendChild(el);
        return el;
    }
}

