/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary.messages.ddconfig;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.ConfigurationException;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfigCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNumberField;
import org.eclipse.smila.search.utils.search.DFieldCodec;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.INFParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DNumberFieldCodec {
    public static DFieldConfig decode(Element element) throws ConfigurationException {
        DNumberField dNumberField = new DNumberField();
        DFieldConfigCodec.decodeStandardValues(dNumberField, element);
        try {
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                String ln = nl.item(i).getLocalName();
                if (ln != null && ln.equals("Parameter")) {
                    dNumberField.setParameter((INFParameter)DFieldCodec.getParameter((Element)((Element)nl.item(i))));
                }
                ++i;
            }
        }
        catch (DSearchException e) {
            throw new ConfigurationException(e.getMessage());
        }
        return dNumberField;
    }

    public static Element encode(DNumberField dNumberField, Element element) throws ConfigurationException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/DataDictionary/Configuration", "FieldConfig");
        el.setAttribute("xsi:type", "FTNumber");
        DFieldConfigCodec.encodeStandardValues(dNumberField, el);
        if (dNumberField.getParameter() != null) {
            Class encoder = dNumberField.getParameter().getCodecClass();
            Method m = null;
            if (encoder != null) {
                try {
                    m = encoder.getMethod("encode", INFParameter.class, Element.class);
                }
                catch (NoSuchMethodException e) {
                    throw new ConfigurationException("unable to locate encoder method", e);
                }
                try {
                    m.invoke(null, dNumberField.getParameter(), el);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationException("unable to invoke encoder method", e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("unable to invoke encoder method", e);
                }
            }
            throw new ConfigurationException("encoder for parameter must not be equal to null");
        }
        element.appendChild(el);
        return el;
    }
}

