/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.security;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.security.SecurityAttributes;

public final class SecurityAttribute {
    private final AnyMap _mObject;
    private AnyMap _attribute;
    private DataFactory _factory;

    public SecurityAttribute(Record record) {
        this(record.getMetadata(), record.getFactory());
    }

    public SecurityAttribute(AnyMap metadata) {
        this(metadata, null);
    }

    public SecurityAttribute(AnyMap metadata, DataFactory factory) {
        this._mObject = metadata;
        this._factory = factory != null ? factory : DataFactoryCreator.createDefaultFactory();
    }

    public AnyMap getAccessRights() {
        if (this._attribute == null) {
            this._attribute = this.ensureAnyMap(this._mObject, "_accessRights");
        }
        return this._attribute;
    }

    public AnyMap getAccessRights(SecurityAttributes.AccessRightType accessRightType) {
        return this.ensureAnyMap(this.getAccessRights(), accessRightType.name());
    }

    public AnySeq getAccessRights(SecurityAttributes.AccessRightType accessRightType, SecurityAttributes.EntityType entityType) {
        AnyMap accessRights = this.ensureAnyMap(this.getAccessRights(), accessRightType.name());
        return this.ensureAnySeq(accessRights, entityType.name());
    }

    public void add(SecurityAttributes.AccessRightType accessRightType, SecurityAttributes.EntityType entityType, String entity) {
        AnySeq accessRightsList = this.getAccessRights(accessRightType, entityType);
        accessRightsList.add((Object)this._factory.createStringValue(entity));
    }

    public void remove() {
        this._mObject.remove((Object)"_accessRights");
    }

    public void remove(SecurityAttributes.AccessRightType accessRightType) {
        this.getAccessRights().remove((Object)accessRightType.name());
    }

    public void remove(SecurityAttributes.AccessRightType accessRightType, SecurityAttributes.EntityType entityType) {
        this.getAccessRights(accessRightType).remove((Object)entityType.name());
    }

    public void remove(SecurityAttributes.AccessRightType accessRightType, SecurityAttributes.EntityType entityType, String entity) {
        this.getAccessRights(accessRightType, entityType).remove((Object)this._factory.createStringValue(entity));
    }

    private AnyMap ensureAnyMap(AnyMap targetMap, String name) {
        if (targetMap.containsKey((Object)name)) {
            return targetMap.getMap(name);
        }
        AnyMap attribute = this._factory.createAnyMap();
        targetMap.put((Object)name, (Object)attribute);
        return attribute;
    }

    private AnySeq ensureAnySeq(AnyMap targetMap, String name) {
        if (targetMap.containsKey((Object)name)) {
            return targetMap.getSeq(name);
        }
        AnySeq attribute = this._factory.createAnySeq();
        targetMap.put((Object)name, (Object)attribute);
        return attribute;
    }
}

