/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.index;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.index.IndexManager;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;

public abstract class IndexAdmin {
    public static final String DELIMITER = "##";
    protected static final long SLEEP_TIME = 2000L;
    private final Log _log = LogFactory.getLog(this.getClass());

    public void create(DIndexStructure dIndexStructure) throws IndexException {
        this.createIndex(dIndexStructure);
    }

    public void delete(String indexName) throws IndexException {
        this.checkIndexExist(indexName);
        this.checkIndexNotBusy(indexName);
        IndexManager.noUse(indexName);
        IndexManager.deleteIndexUsage(indexName);
        try {
            DataDictionaryController.deleteIndex((String)indexName);
        }
        catch (DataDictionaryException e) {
            throw new IndexException(e);
        }
        this.deleteIndex(indexName);
    }

    public void rename(String indexName, String newIndexName) throws IndexException {
        this.checkIndexExist(indexName);
        this.checkIndexNotBusy(indexName);
        this.checkIndexNotExist(newIndexName);
        try {
            try {
                IndexManager.noUse(indexName);
                DataDictionaryController.renameIndex((String)indexName, (String)newIndexName);
                this.renameIndex(indexName, newIndexName);
                IndexManager.deleteIndexUsage(indexName);
            }
            catch (DataDictionaryException e) {
                throw new IndexException(e);
            }
        }
        finally {
            IndexManager.multiUse(newIndexName);
        }
    }

    public void save(String indexName) throws IndexException {
        this.checkIndexExist(indexName);
        this.checkIndexNotBusy(indexName);
        try {
            IndexManager.noUse(indexName);
            this.saveIndex(indexName);
        }
        finally {
            IndexManager.multiUse(indexName);
        }
    }

    public abstract void saveIndex(String var1) throws IndexException;

    protected abstract void createIndex(DIndexStructure var1) throws IndexException;

    protected abstract void deleteIndex(String var1) throws IndexException;

    protected abstract void renameIndex(String var1, String var2) throws IndexException;

    public boolean exists(String indexName) throws IndexException {
        try {
            if (!DataDictionaryController.hasIndex((String)indexName)) {
                return false;
            }
        }
        catch (DataDictionaryException e) {
            throw new IndexException(e);
        }
        return this.indexExists(indexName);
    }

    public String existsIgnoreCase(String indexName) throws IndexException {
        String name;
        block4: {
            try {
                name = DataDictionaryController.getExistingIndexName((String)indexName);
                if (name != null) break block4;
                return null;
            }
            catch (DataDictionaryException e) {
                throw new IndexException(e.getMessage());
            }
        }
        if (this.exists(name)) {
            return name;
        }
        return null;
    }

    protected abstract boolean indexExists(String var1) throws IndexException;

    public void reorganize(String indexName) throws IndexException {
        this.checkIndexExist(indexName);
        this.checkIndexNotBusy(indexName);
        try {
            try {
                IndexManager.noUse(indexName);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                this.reorganizeIndex(indexName);
            }
            catch (Throwable throwable) {
                throw new IndexException("unable to reorganize index [" + indexName + "]");
            }
        }
        finally {
            IndexManager.multiUse(indexName);
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("index reorganized [" + indexName + "]"));
        }
    }

    protected abstract void reorganizeIndex(String var1) throws IndexException;

    private void checkIndexExist(String indexName) throws IndexException {
        if (!this.exists(indexName)) {
            throw new IndexException("index does not exist [" + indexName + "]");
        }
    }

    private void checkIndexNotExist(String indexName) throws IndexException {
        if (this.exists(indexName)) {
            throw new IndexException("index [" + indexName + "] already exists!");
        }
    }

    private void checkIndexNotBusy(String indexName) throws IndexException {
        if (IndexManager.isIndexBusy(indexName)) {
            throw new IndexException(String.format("Index [%s] is busy!", indexName));
        }
    }
}

