/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.index;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DConnection;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.index.IndexCleaner;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.index.IndexConnectionUsage;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.index.IndexSingleUseException;
import org.eclipse.smila.search.index.IndexUsage;
import org.eclipse.smila.search.index.Usage;
import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginFactory;

public abstract class IndexManager {
    private static IndexCleaner s_cleaner = new IndexCleaner();
    private static Hashtable<String, IndexUsage> s_indexUsages = new Hashtable(0);

    private IndexManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexConnection getInstance(String indexName) throws IndexException {
        Log log = LogFactory.getLog(IndexManager.class);
        if (s_cleaner != null) {
            // empty if block
        }
        IndexConnection indexConnection = null;
        DIndex dIndex = null;
        try {
            dIndex = DataDictionaryController.getIndex((String)indexName);
        }
        catch (DataDictionaryException e) {
            throw new IndexException(e.getMessage());
        }
        if (dIndex == null) {
            throw new IndexException("index not in data dictionary [" + indexName + "]");
        }
        DConnection dConnection = dIndex.getConnection();
        IndexConnectionUsage indexConUsage2 = null;
        IndexUsage iu = null;
        while (indexConnection == null) {
            IndexUsage indexUsage = iu = IndexManager.getIndexUsage(indexName);
            synchronized (indexUsage) {
                if (iu._usage != Usage.Multi) {
                    throw new IndexSingleUseException("index is not in multi use mode [" + indexName + "]");
                }
                for (IndexConnectionUsage indexConUsage2 : iu._indexConnectionUsages) {
                    if (indexConUsage2._atWork) continue;
                    indexConnection = indexConUsage2._indexConnection;
                    indexConUsage2._atWork = true;
                    break;
                }
                if (indexConnection == null && dConnection.getMaxConnections() > iu._indexConnectionUsages.size()) {
                    indexConUsage2 = new IndexConnectionUsage();
                    indexConUsage2._atWork = true;
                    indexConUsage2._idleSince = System.currentTimeMillis();
                    Plugin plugin = PluginFactory.getPlugin();
                    indexConnection = indexConUsage2._indexConnection = plugin.getIndexAccess().getIndexConnection(indexName);
                    iu._indexConnectionUsages.add(indexConUsage2);
                }
            }
            if (indexConnection != null) continue;
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                log.error((Object)"SLEEP!", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("get index [" + indexConnection + "]"));
        }
        return indexConnection;
    }

    public static void releaseInstance(IndexConnection indexConnection) {
        IndexManager.releaseInstance(indexConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance(IndexConnection indexConnection, boolean destroy) {
        IndexUsage iu;
        Log log = LogFactory.getLog(IndexManager.class);
        IndexConnectionUsage indexConUsage = null;
        IndexUsage indexUsage = iu = IndexManager.getIndexUsage(indexConnection.getName());
        synchronized (indexUsage) {
            Iterator<IndexConnectionUsage> it = iu._indexConnectionUsages.iterator();
            while (it.hasNext()) {
                indexConUsage = it.next();
                if (indexConUsage._indexConnection != indexConnection) continue;
                indexConUsage._idleSince = System.currentTimeMillis();
                indexConUsage._atWork = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("index released [" + indexConnection + "]"));
                }
                if (!destroy) break;
                it.remove();
                indexConUsage._indexConnection.close();
                if (iu._indexConnectionUsages.size() == 0 && iu._usage != Usage.None) {
                    s_indexUsages.remove(indexConnection.getName());
                }
                indexConUsage._indexConnection = null;
                indexConUsage = null;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("index destroyed [" + indexConnection + "]"));
                break;
            }
            iu._idleSince = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doGarbageCollection() {
        Hashtable<String, IndexUsage> hashtable = s_indexUsages;
        synchronized (hashtable) {
            Iterator<IndexUsage> it = s_indexUsages.values().iterator();
            while (it.hasNext()) {
                IndexUsage iu = it.next();
                Iterator<IndexConnectionUsage> icus = iu._indexConnectionUsages.iterator();
                while (icus.hasNext()) {
                    IndexConnectionUsage icu = icus.next();
                    if (icu._atWork) continue;
                    long l = System.currentTimeMillis() - icu._idleSince;
                    icu.getClass();
                    if (l <= 120000L) continue;
                    icus.remove();
                    icu._indexConnection.close();
                    icu = null;
                }
                if (iu._indexConnectionUsages.size() != 0 || iu._usage == Usage.None || System.currentTimeMillis() - iu._idleSince <= 5000L) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteIndexUsage(String indexName) throws IndexException {
        Hashtable<String, IndexUsage> hashtable = s_indexUsages;
        synchronized (hashtable) {
            IndexUsage iu = IndexManager.getIndexUsage(indexName);
            if (iu == null) {
                throw new IndexException("index does not exist [" + indexName + "]");
            }
            IndexUsage indexUsage = iu;
            synchronized (indexUsage) {
                if (iu._usage != Usage.None) {
                    throw new IndexException("index in use [" + indexName + "]");
                }
                s_indexUsages.remove(indexName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void noUse(String indexName) throws IndexException {
        IndexUsage iu = null;
        IndexUsage indexUsage = iu = IndexManager.getIndexUsage(indexName);
        synchronized (indexUsage) {
            if (Usage.None == iu._usage) {
                throw new IndexException(String.format("Index [%s] already in noUse state!", indexName));
            }
            iu._usage = Usage.None;
            Iterator<IndexConnectionUsage> iter = iu._indexConnectionUsages.iterator();
            while (iter.hasNext()) {
                IndexConnectionUsage icu = iter.next();
                IndexConnection ic = icu._indexConnection;
                ic.close();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexUsage getIndexUsage(String indexName) {
        Hashtable<String, IndexUsage> hashtable = s_indexUsages;
        synchronized (hashtable) {
            IndexUsage iu = null;
            iu = s_indexUsages.get(indexName);
            if (iu == null) {
                iu = new IndexUsage();
                iu._indexName = indexName;
                s_indexUsages.put(indexName, iu);
            }
            return iu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void singleUse(IndexConnection indexConnection) throws IndexException {
        IndexUsage iu = null;
        IndexUsage indexUsage = iu = IndexManager.getIndexUsage(indexConnection.getName());
        synchronized (indexUsage) {
            if (Usage.Multi != iu._usage) {
                throw new IndexException(String.format("Index [%s] in [%s] state!", new Object[]{indexConnection.getName(), iu._usage}));
            }
            iu._usage = Usage.Single;
            Iterator<IndexConnectionUsage> iter = iu._indexConnectionUsages.iterator();
            while (iter.hasNext()) {
                IndexConnectionUsage icu = iter.next();
                IndexConnection ic = icu._indexConnection;
                if (ic == indexConnection) continue;
                ic.close();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void multiUse(String indexName) throws IndexException {
        Hashtable<String, IndexUsage> hashtable = s_indexUsages;
        synchronized (hashtable) {
            IndexManager.getIndexUsage((String)indexName)._usage = Usage.Multi;
        }
    }

    public static void startBurstmode(IndexConnection indexConnection) throws IndexException {
        try {
            IndexManager.singleUse(indexConnection);
            indexConnection.startBurstmode();
        }
        catch (IndexException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexException("unable to start burstmode [" + indexConnection.getName() + "]", e);
        }
    }

    public static void stopBurstmode(IndexConnection indexConnection) throws IndexException {
        try {
            try {
                indexConnection.stopBurstmode();
            }
            catch (Exception e) {
                throw new IndexException("unable to stop burstmode [" + indexConnection.getName() + "]", e);
            }
        }
        finally {
            IndexManager.multiUse(indexConnection.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws IndexException {
        Hashtable<String, IndexUsage> hashtable = s_indexUsages;
        synchronized (hashtable) {
            for (IndexUsage iu : s_indexUsages.values()) {
                Iterator<IndexConnectionUsage> icus = iu._indexConnectionUsages.iterator();
                while (icus.hasNext()) {
                    IndexConnectionUsage icu = icus.next();
                    icus.remove();
                    icu._indexConnection.close();
                    icu = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIndexBusy(String indexName) throws IndexException {
        IndexUsage iu;
        boolean alreadyUsed = true;
        Hashtable<String, IndexUsage> hashtable = s_indexUsages;
        synchronized (hashtable) {
            alreadyUsed = s_indexUsages.containsKey(indexName);
        }
        IndexUsage indexUsage = iu = IndexManager.getIndexUsage(indexName);
        synchronized (indexUsage) {
            block7: {
                if (!alreadyUsed || System.currentTimeMillis() - iu._idleSince >= 2500L) break block7;
                return true;
            }
            return false;
        }
    }
}

