/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.plugin;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.search.EIFActivator;
import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginException;

public class PluginFactory {
    public static final String EXTENSION_POINT_NAME_PLUGIN = "org.eclipse.smila.search.plugin";
    private static Object s_object = new Object();
    private static Plugin s_plugin;

    private PluginFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws PluginException {
        Object object = s_object;
        synchronized (object) {
            String pluginName = null;
            try {
                EIFActivator.registerSchemas();
                s_plugin = PluginFactory.getInstance();
            }
            catch (Throwable e) {
                throw new PluginException("unable to instanciate retrieval plugin [" + pluginName + "]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Plugin getPlugin() {
        Object object = s_object;
        synchronized (object) {
            block6: {
                Log log = LogFactory.getLog(PluginFactory.class);
                if (s_plugin == null) {
                    try {
                        PluginFactory.initialize();
                    }
                    catch (PluginException exception) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)exception);
                    }
                }
            }
            return s_plugin;
        }
    }

    public static Plugin getInstance() {
        Plugin[] types;
        block5: {
            Log log = LogFactory.getLog(PluginFactory.class);
            try {
                types = PluginFactory.getTypes();
                if (types.length == 1) break block5;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("invalid plugin count [" + types.length + "]"));
                }
                return null;
            }
            catch (PluginException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                return null;
            }
        }
        return types[0];
    }

    public static Plugin[] getTypes() throws PluginException {
        Log log = LogFactory.getLog(PluginFactory.class);
        ArrayList<Plugin> found = new ArrayList<Plugin>();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_NAME_PLUGIN).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                PluginFactory.parseType(configurationElement, found.size());
                Plugin clazz = null;
                try {
                    Object obj = configurationElement.createExecutableExtension("Clazz");
                    clazz = (Plugin)obj;
                }
                catch (Exception exception) {
                    if (log.isErrorEnabled()) {
                        if (configurationElement != null) {
                            log.error((Object)"Failed to instantiate plugin");
                        } else {
                            log.error((Object)"Unknown!");
                        }
                    }
                    throw new PluginException("unable to load plugin", exception);
                }
                if (clazz != null) {
                    found.add(clazz);
                }
                ++j;
            }
            ++i;
        }
        return found.toArray(new Plugin[0]);
    }

    public static String parseType(IConfigurationElement configurationElement, int ordinal) {
        Log log = LogFactory.getLog(PluginFactory.class);
        if (!configurationElement.getName().equals("Plugin")) {
            return null;
        }
        try {
            String name = configurationElement.getAttribute("Clazz");
            if (name == null) {
                name = "[missing attribute name]";
            }
            return name;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String name = configurationElement.getAttribute("Clazz");
                if (name == null) {
                    name = "[missing attribute name]";
                }
                String msg = "Failed to load plugin named " + name + " in " + configurationElement.getDeclaringExtension().getNamespaceIdentifier();
                log.error((Object)msg, (Throwable)e);
            }
            return null;
        }
    }
}

