/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.framework.CrawlState;
import org.eclipse.smila.connectivity.framework.Crawler;
import org.eclipse.smila.connectivity.framework.CrawlerController;
import org.eclipse.smila.connectivity.framework.impl.AbstractController;
import org.eclipse.smila.connectivity.framework.impl.CrawlThread;
import org.eclipse.smila.connectivity.framework.schema.config.DataConnectionID;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.CrawlThreadState;
import org.eclipse.smila.connectivity.framework.util.CrawlerControllerCallback;
import org.osgi.service.component.ComponentContext;

public class CrawlerControllerImpl
extends AbstractController
implements CrawlerController,
CrawlerControllerCallback {
    private static final String BUNDLE_ID = "org.eclipse.smila.connectivity.framework";
    private static final long CRAWL_THREAD_JOIN_TIME = 5000L;
    private final Log _log = LogFactory.getLog(CrawlerControllerImpl.class);
    private final Map<String, CrawlThread> _crawlThreads;
    private final Map<String, CrawlState> _crawlStates;

    public CrawlerControllerImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Creating CrawlerControllerImpl");
        }
        this._crawlThreads = new HashMap<String, CrawlThread>();
        this._crawlStates = new HashMap<String, CrawlState>();
    }

    public int startCrawl(String dataSourceId) throws ConnectivityException {
        if (dataSourceId == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter dataSourceId is null");
            }
            throw new NullPointerException("Parameter dataSourceId is null");
        }
        if (this._crawlThreads.containsKey(dataSourceId)) {
            throw new ConnectivityException("Can't start a new crawl for DataSourceId '" + dataSourceId + "'. It is already crawled by another process.");
        }
        try {
            DataSourceConnectionConfig configuration = this.getConfiguration(BUNDLE_ID, dataSourceId);
            Crawler crawler = this.createInstance(Crawler.class, configuration.getDataConnectionID().getId());
            int jobId = crawler.hashCode();
            CrawlState crawlState = new CrawlState();
            crawlState.setDataSourceId(dataSourceId);
            crawlState.setState(CrawlThreadState.Running);
            crawlState.setStartTime(Long.valueOf(System.currentTimeMillis()));
            crawlState.setJobId(Integer.toString(jobId));
            this._crawlStates.put(dataSourceId, crawlState);
            CrawlThread crawlThread = new CrawlThread(this, crawlState, this.getConnectivityManager(), this.getDeltaIndexingManager(), this.getCompoundManager(), crawler, configuration);
            this._crawlThreads.put(dataSourceId, crawlThread);
            crawlThread.start();
            return jobId;
        }
        catch (ConnectivityException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error during executeCrawl of DataSourceId '" + dataSourceId + "'";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new ConnectivityException(msg, (Throwable)e);
        }
    }

    public void stopCrawl(String dataSourceId) throws ConnectivityException {
        if (dataSourceId == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter dataSourceId is null");
            }
            throw new NullPointerException("Parameter dataSourceId is null");
        }
        CrawlThread crawlThread = this._crawlThreads.get(dataSourceId);
        if (crawlThread == null) {
            String msg = "Could not stop crawl for DataSourceId '" + dataSourceId + "'. No CrawlThread exists.";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg);
            }
            throw new ConnectivityException(msg);
        }
        crawlThread.stopCrawl();
    }

    public boolean hasActiveCrawls() throws ConnectivityException {
        return !this._crawlThreads.isEmpty();
    }

    public Map<String, CrawlState> getCrawlerTasksState() {
        HashMap<String, CrawlState> states = new HashMap<String, CrawlState>();
        states.putAll(this._crawlStates);
        return states;
    }

    public void unregister(String dataSourceId) {
        this._crawlThreads.remove(dataSourceId);
    }

    public Collection<String> getAvailableCrawlers() {
        return this.getAvailableFactories();
    }

    public Collection<String> getAvailableConfigurations() {
        return this.getConfigurations(BUNDLE_ID, DataConnectionID.DataConnectionType.CRAWLER);
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)"Deactivating CrawlerController");
        }
        this._lock.writeLock().lock();
        try {
            for (Map.Entry<String, CrawlThread> entry : this._crawlThreads.entrySet()) {
                try {
                    if (entry.getValue() == null) continue;
                    entry.getValue().stopCrawl();
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)("Error stopping CrawlThread for data source " + entry.getKey()), (Throwable)e);
                }
            }
            for (Map.Entry<String, CrawlThread> entry : this._crawlThreads.entrySet()) {
                try {
                    if (entry.getValue() == null) continue;
                    entry.getValue().join(5000L);
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)("Error joining CrawlThread for data source " + entry.getKey()), (Throwable)e);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }
}

