/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.smila.management.jmx.client.cmd.CmdConsoleImpl;
import org.eclipse.smila.management.jmx.client.config.CmdConfigType;
import org.eclipse.smila.management.jmx.client.config.ConnectionConfigType;
import org.eclipse.smila.management.jmx.client.config.JmxClientConfigType;
import org.eclipse.smila.management.jmx.client.helpers.ConfigHelper;
import org.eclipse.smila.management.jmx.client.helpers.ConfigLoader;
import org.eclipse.smila.management.jmx.client.helpers.ConsoleArguments;
import org.eclipse.smila.management.jmx.client.helpers.OutWriter;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        ConsoleArguments arguments;
        if (args.length == 0) {
            Main.printHelp(null);
            return;
        }
        try {
            arguments = ConsoleArguments.parse(args);
        }
        catch (Throwable e) {
            OutWriter.writeOut(e.getMessage());
            Main.printHelp(null);
            return;
        }
        String validateMessage = arguments.validate();
        if (validateMessage != null) {
            OutWriter.writeOut(validateMessage);
            Main.printHelp(arguments);
            return;
        }
        File file = new File(arguments.getConfiguration());
        JmxClientConfigType config = ConfigLoader.load(new FileInputStream(file));
        ConnectionConfigType connectionConfig = ConfigHelper.findConnectionConfig(arguments, config);
        CmdConfigType cmdConfig = ConfigHelper.findCmdConfig(arguments, config);
        CmdConsoleImpl console = new CmdConsoleImpl();
        console.execute(cmdConfig, connectionConfig, arguments.getParameters());
    }

    private static void printHelp(ConsoleArguments arguments) throws Exception {
        OutWriter.writeOut("Usage:\n  run <operation> <parameter 1> <parameter N> -c:<altrnate connection> -f:<altrnate configuration path>\n");
        String configPath = arguments != null ? arguments.getConfiguration() : "config.xml";
        File file = new File(configPath);
        JmxClientConfigType config = ConfigLoader.load(new FileInputStream(file));
        OutWriter.writeOut(ConfigHelper.createHelpString(config, "run"));
    }
}

