/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10.jaxp;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.JaxpFunctionResolver;
import org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.WrappedFaultException;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JaxpXPath10ExpressionRuntime
implements ExpressionLanguageRuntime {
    private static final Log __log = LogFactory.getLog(JaxpXPath10ExpressionRuntime.class);

    public void initialize(Map map) throws ConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        __log.debug((Object)("JAXP runtime: TransformerFactory impl = " + transformerFactory.getClass()));
        XslTransformHandler.getInstance().setTransformerFactory(transformerFactory);
    }

    public String evaluateAsString(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (String)this.evaluate(oExpression, evaluationContext, XPathConstants.STRING);
    }

    public boolean evaluateAsBoolean(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (Boolean)this.evaluate(oExpression, evaluationContext, XPathConstants.BOOLEAN);
    }

    public Number evaluateAsNumber(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (Number)this.evaluate(oExpression, evaluationContext, XPathConstants.NUMBER);
    }

    public List evaluate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List<Node> list;
        Object object;
        ArrayList<String> arrayList = null;
        try {
            arrayList = this.evaluate(oExpression, evaluationContext, XPathConstants.NODESET);
        }
        catch (FaultException faultException) {
            try {
                object = new ArrayList<String>(1);
                object.add(this.evaluateAsString(oExpression, evaluationContext));
                arrayList = object;
            }
            catch (Exception exception) {
                throw faultException;
            }
        }
        if (arrayList instanceof List) {
            list = (ArrayList<Node>)arrayList;
            __log.debug((Object)("Returned list of size " + list.size()));
            if (list.size() == 1 && !(list.get(0) instanceof Node)) {
                Object e = list.get(0);
                object = e instanceof Date ? ISO8601DateParser.format((Date)((Date)e)) : e.toString();
                Document document = DOMUtils.newDocument();
                Element element = document.createElement("wrapper");
                Text text = document.createTextNode((String)object);
                element.appendChild(text);
                document.appendChild(element);
                list = Collections.singletonList(text);
            }
        } else if (arrayList instanceof NodeList) {
            NodeList nodeList = (NodeList)((Object)arrayList);
            __log.debug((Object)("Returned node list of size " + nodeList.getLength()));
            list = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                list.add(node);
            }
        } else {
            list = null;
        }
        return list;
    }

    public Node evaluateNode(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = this.evaluate(oExpression, evaluationContext);
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        return (Node)list.get(0);
    }

    public Calendar evaluateAsDate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = DOMUtils.toList((Object)this.evaluate(oExpression, evaluationContext, XPathConstants.NODESET));
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        Object object = list.get(0);
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        if (object instanceof Element) {
            object = ((Element)object).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal((String)object.toString());
        }
        catch (Exception exception) {
            String string = "Invalid date format: " + list;
            __log.error((Object)string);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string);
        }
    }

    public Duration evaluateAsDuration(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        String string = this.evaluateAsString(oExpression, evaluationContext);
        try {
            return new Duration(string);
        }
        catch (Exception exception) {
            String string2 = "Invalid duration: " + string;
            __log.error((Object)string2, (Throwable)exception);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string2);
        }
    }

    private Object evaluate(OExpression oExpression, EvaluationContext evaluationContext, QName qName) throws FaultException {
        try {
            OXPath10Expression oXPath10Expression = (OXPath10Expression)oExpression;
            __log.debug((Object)("JAXP runtime: evaluating " + oXPath10Expression.xpath));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            __log.debug((Object)("JAXP runtime: XPathFactory impl = " + xPathFactory.getClass()));
            XPath xPath = xPathFactory.newXPath();
            xPath.setXPathFunctionResolver(new JaxpFunctionResolver(evaluationContext, oXPath10Expression));
            xPath.setXPathVariableResolver(new JaxpVariableResolver(evaluationContext, oXPath10Expression));
            xPath.setNamespaceContext((NamespaceContext)oXPath10Expression.namespaceCtx);
            XPathExpression xPathExpression = xPath.compile(((OXPath10Expression)oExpression).xpath);
            Object object = xPathExpression.evaluate(evaluationContext.getRootNode() == null ? DOMUtils.newDocument() : evaluationContext.getRootNode(), qName);
            if (object != null && __log.isDebugEnabled()) {
                __log.debug((Object)("Expression " + oExpression.toString() + " generated result " + object + " - type=" + object.getClass().getName()));
                if (evaluationContext.getRootNode() != null) {
                    __log.debug((Object)("Was using context node " + DOMUtils.domToString((Node)evaluationContext.getRootNode())));
                }
            }
            return object;
        }
        catch (XPathExpressionException xPathExpressionException) {
            Throwable throwable = xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException;
            throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, throwable.getMessage(), throwable);
        }
        catch (WrappedFaultException wrappedFaultException) {
            __log.debug((Object)"Could not evaluate expression because of ", (Throwable)wrappedFaultException);
            throw (FaultException)wrappedFaultException.getCause();
        }
        catch (Throwable throwable) {
            __log.debug((Object)"Could not evaluate expression because of ", throwable);
            throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, throwable.getMessage(), throwable);
        }
    }
}

