/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.AbstractCrawler;
import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.crawler.web.IndexDocument;
import org.eclipse.smila.connectivity.framework.crawler.web.WebCrawlerPerformanceAgent;
import org.eclipse.smila.connectivity.framework.crawler.web.WebSiteIterator;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.Attribute;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.FieldAttributeType;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.MetaReturnType;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.MetaType;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.Process;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.WebSite;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.ParserManager;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.DataReferenceFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.utils.collections.NameValuePair;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public class WebCrawler
extends AbstractCrawler {
    public static final String POC_BYTES = "bytes";
    public static final String POC_PAGES = "pages";
    public static final String POC_PRODUCER_EXCEPTIONS = "producerExceptions";
    public static final String POC_AVEREGE_TIME_TO_FETCH = "averageHttpFetchTime";
    private static final String BUNDLE_NAME = "org.eclipse.smila.connectivity.framework.crawler.web";
    private static final String UTF_8 = "utf-8";
    private static final char METADATA_SEPARATOR = ':';
    private static final int QUEUE_POLL_WAITING = 300;
    private static final int HAS_NEXT_WAITING = 50;
    private static final int CAPACITY = 100;
    private static final int STEP = 10;
    private final Log _log = LogFactory.getLog(WebCrawler.class);
    private ArrayBlockingQueue<Record> _queue;
    private String _dataSourceID;
    private Attribute[] _attributes;
    private CrawlingProducerThread _crawlThread;
    private Iterator<WebSite> _webSites;
    private WebSiteIterator _webSiteIterator;
    private boolean _opened;
    private boolean _forceClosing;
    private boolean _producerRunning;
    private final Object _openedMonitor = new Object();
    private final DataFactory _factory = DataFactoryCreator.createDefaultFactory();
    private String _workspace;
    private CrawlerCriticalException _criticalException;
    private CrawlerPerformanceCounterHelper<WebCrawlerPerformanceAgent> _performanceCounters;
    private final Pattern _contentTypePattern = Pattern.compile("^CONTENT-TYPE\\s*:\\s*(?:.|\\s)*CHARSET\\s*=\\s*([\\w-]*)", 2);
    private final Pattern _mimeTypePattern = Pattern.compile("^CONTENT-TYPE\\s*:\\s*([^\\s;]+)(\\s*;?.*)$", 2);
    private ParserManager _parserManager;
    private HashMap<ConnectivityId, Record> _dataReferenceRecords = new HashMap();
    private HashMap<ConnectivityId, Record> _records = new HashMap();

    public WebCrawler() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating WebCrawler instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DataSourceConnectionConfig config) throws CrawlerException, CrawlerCriticalException {
        this._log.info((Object)"Initializing WebCrawler...");
        Object object = this._openedMonitor;
        synchronized (object) {
            if (this._opened) {
                throw new CrawlerCriticalException("Crawler is busy (it should not happen because new instances are created by ComponentFactories)");
            }
            this._opened = true;
        }
        this._dataReferenceRecords = new HashMap();
        this._records = new HashMap();
        this._performanceCounters = new CrawlerPerformanceCounterHelper(config, ((Object)((Object)this)).hashCode(), WebCrawlerPerformanceAgent.class);
        this._queue = new ArrayBlockingQueue(100);
        this._forceClosing = false;
        this._producerRunning = true;
        this._dataSourceID = config.getDataSourceID();
        DataSourceConnectionConfig.Attributes attributes = config.getAttributes();
        List attrs = attributes.getAttribute();
        this._attributes = attrs.toArray(new Attribute[attrs.size()]);
        Process process = (Process)config.getProcess();
        this._webSites = process.getWebSite().iterator();
        this.initDataFolder();
        this.initializeNextSite();
        this._crawlThread = new CrawlingProducerThread();
        this._crawlThread.start();
        this._log.debug((Object)"WebCrawler indexer started");
    }

    public DataReference[] getNext() throws CrawlerException, CrawlerCriticalException {
        this.rethrowProducerExceptions();
        while (this.hasNext()) {
            this.rethrowProducerExceptions();
            try {
                ArrayList<Record> list = new ArrayList<Record>();
                Record topRecord = this._queue.poll(300L, TimeUnit.MILLISECONDS);
                if (topRecord == null) continue;
                list.add(topRecord);
                this._queue.drainTo(list, 9);
                DataReference[] dataRefs = new DataReference[list.size()];
                int i = 0;
                while (i < list.size()) {
                    Record record = (Record)list.get(i);
                    AnyMap idAttributes = this._factory.createAnyMap();
                    AnyMap hashAttributes = this._factory.createAnyMap();
                    this.getIdAndHashAttributes(record.getMetadata(), idAttributes, hashAttributes);
                    dataRefs[i] = DataReferenceFactory.getInstance().createDataReference((CrawlerCallback)this, this._dataSourceID, idAttributes, hashAttributes, this.getHashAttachments(record));
                    this._dataReferenceRecords.put(dataRefs[i].getId(), record);
                    ++i;
                }
                return dataRefs;
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CrawlerException {
        Object object = this._openedMonitor;
        synchronized (object) {
            this._opened = false;
            this._log.info((Object)"Closing WebCrawler...");
            this._queue = null;
            this._records.clear();
            this._records = null;
            this._dataReferenceRecords.clear();
            this._dataReferenceRecords = null;
            this._performanceCounters = null;
            this._forceClosing = true;
            if (this._crawlThread != null) {
                try {
                    this._crawlThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (NullPointerException nullPointerException) {}
                this._crawlThread = null;
            }
            this._dataSourceID = null;
            this._attributes = null;
            this._criticalException = null;
            if (this._workspace != null) {
                FileUtils.deleteQuietly((File)new File(this._workspace));
            }
        }
    }

    public AnyMap getMetadata(ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
        Record record = null;
        try {
            record = this.getRecord(id);
        }
        catch (Exception exception) {
            throw new CrawlerException((Throwable)exception);
        }
        return record.getMetadata();
    }

    public byte[] getAttachment(ConnectivityId id, String name) throws CrawlerException, CrawlerCriticalException {
        Record record = null;
        try {
            record = this.getRecord(id);
        }
        catch (Exception exception) {
            throw new CrawlerException((Throwable)exception);
        }
        return record.getAttachment(name);
    }

    public String[] getAttachmentNames(ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
        Record record = null;
        try {
            record = this.getRecord(id);
        }
        catch (Exception exception) {
            throw new CrawlerException((Throwable)exception);
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = record.getAttachmentNames();
        while (it.hasNext()) {
            names.add((String)it.next());
        }
        return names.toArray(new String[names.size()]);
    }

    public void dispose(ConnectivityId id) {
        this._dataReferenceRecords.remove(id);
        this._records.remove(id);
    }

    private void getIdAndHashAttributes(AnyMap metadata, AnyMap idAttributes, AnyMap hashAttributes) {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (!attribute.isAttachment()) {
                if (attribute.isKeyAttribute()) {
                    idAttributes.put((Object)attribute.getName(), (Object)((Any)metadata.get((Object)attribute.getName())));
                } else if (attribute.isHashAttribute()) {
                    hashAttributes.put((Object)attribute.getName(), (Object)((Any)metadata.get((Object)attribute.getName())));
                }
            }
            ++n2;
        }
    }

    private Map<String, byte[]> getHashAttachments(Record record) {
        if (record.hasAttachments()) {
            HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
            Iterator it = record.getAttachmentNames();
            while (it.hasNext()) {
                String attachmentName = (String)it.next();
                hashAttachments.put(attachmentName, record.getAttachment(attachmentName));
            }
            return hashAttachments;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAttribute(Record record, IndexDocument indexDocument, Attribute attribute) throws UnsupportedEncodingException {
        String name = attribute.getName();
        AnyMap metadata = record.getMetadata();
        if (attribute.isAttachment()) {
            Serializable value = this.readAttribute(indexDocument, attribute, false);
            if (value == null) return;
            if (value instanceof String) {
                record.setAttachment(name, ((String)((Object)value)).getBytes(UTF_8));
                return;
            } else {
                if (!(value instanceof byte[])) throw new RuntimeException("Unknown attachment type!");
                record.setAttachment(name, (byte[])value);
            }
            return;
        } else {
            Value metaDataAttribute;
            Serializable value = this.readAttribute(indexDocument, attribute, true);
            if (value == null) return;
            if (value instanceof NameValuePair[]) {
                AnyMap anyMap = this._factory.createAnyMap();
                NameValuePair[] nameValuePairArray = (NameValuePair[])value;
                int n = nameValuePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NameValuePair nameValuePair = nameValuePairArray[n2];
                    anyMap.put((Object)nameValuePair.getName(), (Object)this._factory.createStringValue(nameValuePair.getValue()));
                    ++n2;
                }
                metaDataAttribute = anyMap;
            } else if (value instanceof Object[]) {
                AnySeq anySeq = this._factory.createAnySeq();
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object object = objectArray[n3];
                    anySeq.add((Object)this._factory.parseFromObject(object));
                    ++n3;
                }
                metaDataAttribute = anySeq;
            } else {
                metaDataAttribute = this._factory.parseFromObject((Object)value);
            }
            metadata.put((Object)name, (Object)metaDataAttribute);
        }
    }

    private boolean initializeNextSite() throws CrawlerCriticalException {
        this._webSiteIterator = null;
        if (this._webSites.hasNext()) {
            WebSite site = this._webSites.next();
            this._webSiteIterator = new WebSiteIterator(site, this._parserManager, this._performanceCounters);
            boolean hasNext = this._webSiteIterator.hasNext();
            if (!hasNext) {
                this._forceClosing = true;
                this._criticalException = new CrawlerCriticalException("Unable to connect to web site specified in project " + site.getProjectName());
            }
            return hasNext;
        }
        return false;
    }

    private void rethrowProducerExceptions() throws CrawlerCriticalException {
        if (this._criticalException != null) {
            throw this._criticalException;
        }
    }

    private boolean hasNext() throws CrawlerCriticalException {
        while (this._producerRunning && this._queue.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.rethrowProducerExceptions();
        return !this._queue.isEmpty();
    }

    private Record getRecord(ConnectivityId id) throws IOException, CrawlerException {
        if (this._records.containsKey(id)) {
            return this._records.get(id);
        }
        Record record = this._dataReferenceRecords.get(id);
        AnyMap metadata = record.getMetadata();
        IndexDocument indexDocument = null;
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (!attribute.isHashAttribute() && !attribute.isKeyAttribute()) {
                if (indexDocument == null) {
                    String url = metadata.getStringValue(FieldAttributeType.URL.value());
                    indexDocument = this.deserializeIndexDocument(DigestUtils.md5Hex((String)url));
                }
                this.setAttribute(record, indexDocument, attribute);
            }
            ++n2;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Created record for url: " + metadata.getStringValue(FieldAttributeType.URL.value())));
        }
        this._records.put(id, record);
        this._dataReferenceRecords.remove(id);
        return record;
    }

    private Record createDataReferenceRecord(IndexDocument indexDocument) throws IOException {
        Record record = this._factory.createRecord();
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.isKeyAttribute() || attribute.isHashAttribute() || attribute.getFieldAttribute() != null && attribute.getFieldAttribute().equals((Object)FieldAttributeType.URL)) {
                this.setAttribute(record, indexDocument, attribute);
            }
            ++n2;
        }
        return record;
    }

    private Serializable readAttribute(IndexDocument indexDocument, Attribute attribute, boolean forceByteToString) throws UnsupportedEncodingException {
        if (attribute.getFieldAttribute() != null) {
            switch (attribute.getFieldAttribute()) {
                case URL: {
                    return indexDocument.getUrl();
                }
                case CONTENT: {
                    String charsetName = indexDocument.extractFromResponseHeaders(this._contentTypePattern, 1);
                    if (charsetName == null) {
                        charsetName = UTF_8;
                    }
                    if (forceByteToString) {
                        return new String(indexDocument.getContent(), charsetName);
                    }
                    if (UTF_8.equalsIgnoreCase(charsetName)) {
                        return indexDocument.getContent();
                    }
                    try {
                        return new String(indexDocument.getContent(), charsetName).getBytes(UTF_8);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new UnsupportedEncodingException("Test");
                    }
                }
                case TITLE: {
                    return indexDocument.getTitle();
                }
                case MIME_TYPE: {
                    return indexDocument.extractFromResponseHeaders(this._mimeTypePattern, 1);
                }
            }
            throw new IllegalArgumentException("Unknown field attribute type " + (Object)((Object)attribute.getFieldAttribute()));
        }
        if (attribute.getMetaAttribute() != null) {
            List<String> metaData;
            MetaType metaType = attribute.getMetaAttribute().getType();
            List<String> metaNames = attribute.getMetaAttribute().getMetaName();
            switch (metaType) {
                case META_DATA: {
                    metaData = this.getFilteredMetadataList(indexDocument.getHtmlMetaData(), metaNames);
                    break;
                }
                case RESPONSE_HEADER: {
                    metaData = this.getFilteredMetadataList(indexDocument.getResponseHeaders(), metaNames);
                    break;
                }
                case META_DATA_WITH_RESPONSE_HEADER_FALL_BACK: {
                    metaData = this.getFilteredMetadataList(indexDocument.getMetaDataWithResponseHeaderFallBack(), metaNames);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown meta attribute type " + (Object)((Object)attribute.getFieldAttribute()));
                }
            }
            MetaReturnType returnType = attribute.getMetaAttribute().getReturnType();
            switch (returnType) {
                case META_DATA_STRING: {
                    return metaData.toArray();
                }
                case META_DATA_VALUE: {
                    int i = 0;
                    while (i < metaData.size()) {
                        String metaDataString = metaData.get(i);
                        metaData.set(i, metaDataString.substring(metaDataString.indexOf(58) + 1).trim());
                        ++i;
                    }
                    return metaData.toArray();
                }
                case META_DATA_M_OBJECT: {
                    NameValuePair[] metaDataNameValuePairs = new NameValuePair[metaData.size()];
                    int i = 0;
                    while (i < metaData.size()) {
                        String metaDataString = metaData.get(i);
                        String metadataName = metaDataString.substring(0, metaDataString.indexOf(58)).trim();
                        String metaDataValue = metaDataString.substring(metaDataString.indexOf(58) + 1).trim();
                        metaDataNameValuePairs[i] = new NameValuePair(metadataName, metaDataValue);
                        ++i;
                    }
                    return metaDataNameValuePairs;
                }
            }
            throw new IllegalArgumentException("Unknown meta attribute return type " + (Object)((Object)returnType));
        }
        throw new IllegalArgumentException("Unknown attribute " + attribute.getName());
    }

    private List<String> getFilteredMetadataList(List<String> list, List<String> filters) {
        if (filters.isEmpty()) {
            return list;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String s : list) {
            if (s.indexOf(58) <= 0) continue;
            String metadataName = s.substring(0, s.indexOf(58)).trim();
            for (String metaName : filters) {
                if (!metadataName.equals(metaName)) continue;
                filteredList.add(s);
            }
        }
        return filteredList;
    }

    private void serializeIndexDocument(String filename, IndexDocument indexDocument) throws CrawlerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Serializing document " + filename));
        }
        ObjectOutputStream objstream = null;
        try {
            try {
                objstream = new ObjectOutputStream(new FileOutputStream(new File(this._workspace, filename)));
                objstream.writeObject(indexDocument);
            }
            catch (Throwable e) {
                throw new CrawlerException("Unable to serialize index document", e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(objstream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)objstream);
    }

    private IndexDocument deserializeIndexDocument(String filename) throws CrawlerException {
        File file;
        IndexDocument indexDocument = null;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Deserializing document " + filename));
        }
        if (!(file = new File(this._workspace, filename)).exists()) {
            throw new CrawlerException(String.format("Unable to find file %s for deserializing cached document", file.getPath()));
        }
        ObjectInputStream objstream = null;
        try {
            try {
                objstream = new ObjectInputStream(new FileInputStream(file));
                indexDocument = (IndexDocument)objstream.readObject();
            }
            catch (Throwable e) {
                throw new CrawlerException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(objstream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)objstream);
        return indexDocument;
    }

    private void initDataFolder() throws CrawlerCriticalException {
        try {
            File file = WorkspaceHelper.createWorkingDir((String)BUNDLE_NAME, (String)String.valueOf(((Object)((Object)this)).hashCode()));
            file.mkdir();
            this._workspace = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CrawlerCriticalException("Unable to initialize workspace", (Throwable)e);
        }
    }

    public void setParserManager(ParserManager parserManager) {
        this._parserManager = parserManager;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"ParserManager is bound");
        }
    }

    public void unsetParserManager(ParserManager parserManager) {
        if (parserManager == this._parserManager) {
            this._parserManager = null;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"ParserManager is unbound");
        }
    }

    private class CrawlingProducerThread
    extends Thread {
        private CrawlingProducerThread() {
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    block18: {
                        block17: {
                            if (!true) break block17;
                            if (WebCrawler.this._forceClosing) return;
                            if (!this.hasNextDoc()) break block18;
                        }
                        do {
                            IndexDocument document = WebCrawler.this._webSiteIterator.next();
                            boolean waiting = true;
                            Record record = null;
                            while (waiting) {
                                try {
                                    if (record == null) {
                                        record = WebCrawler.this.createDataReferenceRecord(document);
                                    }
                                    if (WebCrawler.this._forceClosing) break;
                                    WebCrawler.this.serializeIndexDocument(DigestUtils.md5Hex((String)document.getUrl()), document);
                                    if (WebCrawler.this._forceClosing) break;
                                    ArrayBlockingQueue queue = WebCrawler.this._queue;
                                    if (queue != null) {
                                        WebCrawler.this._queue.put(record);
                                    }
                                    waiting = false;
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (IOException e) {
                                    WebCrawler.this._log.error((Object)"", (Throwable)e);
                                    WebCrawler.this._performanceCounters.increment(WebCrawler.POC_PRODUCER_EXCEPTIONS);
                                    WebCrawler.this._performanceCounters.addException((Throwable)e);
                                }
                            }
                            if (WebCrawler.this._forceClosing) return;
                        } while (this.hasNextDoc());
                    }
                    return;
                }
                catch (Throwable t) {
                    WebCrawler.this._log.error((Object)"Producer error", t);
                    if (WebCrawler.this._performanceCounters != null) {
                        WebCrawler.this._performanceCounters.increment(WebCrawler.POC_PRODUCER_EXCEPTIONS);
                        WebCrawler.this._performanceCounters.addException(t);
                    }
                    WebCrawler.this._webSiteIterator = null;
                    WebCrawler.this._producerRunning = false;
                    if (WebCrawler.this._forceClosing) {
                        WebCrawler.this._log.info((Object)"Producer finished by forcing close procedure");
                        return;
                    }
                    WebCrawler.this._log.info((Object)"Producer finished!");
                    return;
                }
            }
            finally {
                WebCrawler.this._webSiteIterator = null;
                WebCrawler.this._producerRunning = false;
                if (WebCrawler.this._forceClosing) {
                    WebCrawler.this._log.info((Object)"Producer finished by forcing close procedure");
                } else {
                    WebCrawler.this._log.info((Object)"Producer finished!");
                }
            }
        }

        private boolean hasNextDoc() throws CrawlerCriticalException {
            if (WebCrawler.this._webSiteIterator.hasNext()) {
                return true;
            }
            if (WebCrawler.this._webSites.hasNext()) {
                return WebCrawler.this.initializeNextSite();
            }
            return false;
        }
    }
}

