/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.parse;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.net.UrlNormalizerFactory;

public class Outlink {
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final Map<String, Integer> DEFAULT_PORTS = new HashMap<String, Integer>();
    private URL _url;
    private URI _uri;
    private String _urlString;
    private String _anchor;

    static {
        DEFAULT_PORTS.put("http", new Integer(80));
        DEFAULT_PORTS.put("https", new Integer(443));
    }

    public Outlink() {
    }

    public Outlink(String urlString, String anchor, Configuration conf) throws MalformedURLException {
        this._urlString = new UrlNormalizerFactory(conf).getNormalizer().normalize(urlString);
        this._url = new URL(this._urlString);
        this._anchor = anchor;
        try {
            this._uri = new URI(this._urlString);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                this._uri = new URI(URIUtil.encodePathQuery((String)this._urlString));
            }
            catch (URIException uRIException) {
                this._uri = null;
            }
            catch (URISyntaxException uRISyntaxException2) {
                this._uri = null;
            }
        }
    }

    public String getUrlString() {
        return this._urlString;
    }

    public String getAnchor() {
        return this._anchor;
    }

    public URL getUrl() {
        return this._url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Outlink)) {
            return false;
        }
        Outlink other = (Outlink)o;
        if (this._uri != null) {
            return this._uri.equals(other._uri);
        }
        return this._urlString.equals(other._urlString);
    }

    public int hashCode() {
        if (this._uri != null) {
            return this._uri.hashCode();
        }
        return this._urlString.hashCode();
    }

    public String toString() {
        return "url: " + this._urlString + " anchor: " + this._anchor;
    }

    public static int getDefaultPortNumber(String protocol) {
        if (protocol == null) {
            return -1;
        }
        Integer defaultPort = DEFAULT_PORTS.get(protocol = protocol.toLowerCase());
        if (defaultPort != null) {
            return defaultPort;
        }
        return -1;
    }
}

